/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.executionhandler.handlers;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.exe.IExecutable;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.executionhandler.handlers.WorkOrderCreatorConfigReader;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.messageprocessor.CommandManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class WorkOrderCreatorAction
implements IExecutable {
    private static final long serialVersionUID = 1L;
    private static final String CONSTANT_UID = "uid";
    private static final String CONSTANT_SELECTOR = "selector";
    private String configFile;

    public void abort() {
    }

    public void execute(ExecutionContext ec) throws Exception {
        WorkflowMessage requestMessage = this.createMessage(ec);
        this.storeMessage(ec.getToken(), ec.getNode(), requestMessage, false);
        WorkflowMessage responseMessage = CommandManager.createAndExecute((WorkflowMessage)requestMessage);
        this.storeMessage(ec.getToken(), ec.getNode(), responseMessage, true);
        this.validateResponse(responseMessage);
    }

    private WorkflowMessage createMessage(ExecutionContext ec) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map<String, String> constants = null;
        Map<String, String> variables = null;
        try {
            constants = WorkOrderCreatorConfigReader.getInstance().getConstants(this.configFile);
            variables = WorkOrderCreatorConfigReader.getInstance().getVariables(this.configFile);
        }
        catch (Exception e) {
            throw new ActionException("Exception while reading the config file for this ActionHandler.", (Throwable)e);
        }
        String uid = constants.remove(CONSTANT_UID);
        String selector = constants.remove(CONSTANT_SELECTOR);
        parameters.putAll(constants);
        Map<String, String> variableNameValueMap = this.getVariableValuesFromContext(ec, variables.keySet());
        Map<String, String> variablesMappedNameValueMap = this.changeNameToMappedName(variables, variableNameValueMap);
        parameters.putAll(variablesMappedNameValueMap);
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)uid);
        WorkflowPayload payload = new WorkflowPayload();
        message.setPayload(payload);
        for (Map.Entry parameter : parameters.entrySet()) {
            payload.putValue((String)parameter.getKey(), (String)parameter.getValue());
        }
        String priorityOfThisWorkOrder = ((WorkflowProcess)ec.getProcessInstance()).getPriority().name();
        message.setCommand(this.createCommand(selector, priorityOfThisWorkOrder));
        return message;
    }

    private Map<String, String> getVariableValuesFromContext(ExecutionContext ec, Collection<String> variableNames) {
        HashMap<String, String> variableNameValueMap = new HashMap<String, String>();
        for (String variableName : variableNames) {
            Object objValue = ec.getVariable(variableName);
            String strValue = objValue != null ? objValue.toString() : null;
            variableNameValueMap.put(variableName, strValue);
        }
        return variableNameValueMap;
    }

    private Map<String, String> changeNameToMappedName(Map<String, String> variables, Map<String, String> variableNameValueMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            String resultVariableName = variable.getValue() != null && variable.getValue().trim().length() > 0 ? variable.getValue() : variable.getKey();
            result.put(resultVariableName, variableNameValueMap.get(variable.getKey()));
        }
        return result;
    }

    private WPCLCommand createCommand(String selector, String priority) {
        WPCLCommand command = new WPCLCommand("create");
        command.addParameter(CONSTANT_SELECTOR, selector);
        command.addParameter("priority", priority);
        return command;
    }

    private void validateResponse(WorkflowMessage responseMessage) {
        if (responseMessage.getType() == WorkflowMessage.MessageType.nack) {
            throw new ActionException(responseMessage.getValue("error-message"));
        }
    }

    private void storeMessage(Token token, Node node, WorkflowMessage message, boolean incoming) {
        WorkflowMessageLogEvent logEvent = new WorkflowMessageLogEvent(token, node, incoming, message);
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)logEvent);
    }
}

