/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.adaptor;

import com.tandbergtv.workflow.adaptor.conf.HandlerParameter;
import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.CommandInserter;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AMSAssetArrivalFailureHandler
extends CommandInserter {
    private static final Logger logger = Logger.getLogger(AMSAssetArrivalFailureHandler.class);

    public AMSAssetArrivalFailureHandler() {
    }

    public AMSAssetArrivalFailureHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        logger.debug((Object)("Processing message: " + msg));
        String messageContent = msg.getPayload().getContent();
        try {
            messageContent = this.transformMessage(messageContent);
        }
        catch (Exception e) {
            throw new HandlerException("Cannot transform the message. Message Content: " + messageContent, (Throwable)e);
        }
        HTTPMessage result = this.constructMessage(messageContent, msg);
        logger.debug((Object)("Processed Message: " + result));
        return result;
    }

    private String transformMessage(String message) throws Exception {
        Document doc = XMLDocumentUtility.loadXml((String)message);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node wfsMessageNode = (Node)xpath.evaluate("//WFSMessage", doc, XPathConstants.NODE);
        NamedNodeMap attributes = wfsMessageNode.getAttributes();
        Node typeAttribute = attributes.getNamedItem("Type");
        IHandlerConfiguration conf = this.getConfiguration();
        String command = "";
        if (typeAttribute != null && typeAttribute.getNodeValue().equals("nack")) {
            typeAttribute.setNodeValue("control");
            command = conf.getParameterValue("NACK_COMMAND");
        } else {
            command = conf.getParameterValue("ACK_COMMAND");
        }
        logger.debug((Object)("command=" + command));
        if (command == null || command.equals("")) {
            command = "null";
        }
        wfsMessageNode.appendChild(this.createCommandParameter(doc, command));
        return XMLDocumentUtility.convertToString((Node)doc);
    }

    private Element createCommandParameter(Document doc, String commandName) {
        String selector;
        Element commandElement = doc.createElement("Command");
        commandElement.setAttribute("Name", commandName);
        if (!commandName.equalsIgnoreCase("null") && (selector = this.getConfiguration().getParameterValue(HandlerParameter.SELECTOR)) != null) {
            Element parameter = doc.createElement("CommandParameter");
            parameter.setAttribute("Name", "selector");
            parameter.setAttribute("Value", selector);
            commandElement.appendChild(parameter);
        }
        return commandElement;
    }

    private HTTPMessage constructMessage(String content, IMessage originalMessage) {
        HTTPPayload payload = new HTTPPayload(content);
        HTTPAttachment attachment = null;
        if (originalMessage.getAttachment() != null) {
            Object attachContent = originalMessage.getAttachment().getContent();
            String attachType = originalMessage.getAttachment().getContentType();
            attachment = new HTTPAttachment(attachContent, attachType);
        }
        return new HTTPMessage(payload, attachment);
    }
}

