/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.adaptor;

import com.tandbergtv.workflow.adaptor.conf.DispatcherParameter;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageAttachment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class CMSSOAPDispatcher
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(CMSSOAPDispatcher.class);

    public CMSSOAPDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public IMessage send(IMessage msg) throws DispatcherException {
        HTTPMessage responseMessage = null;
        String response = " ";
        try {
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            if (msg.getAttachment() != null) {
                this.buildAttachment(message, msg.getAttachment());
            }
            MimeHeaders headers = message.getMimeHeaders();
            String soapAction = this.getConfiguration().getParameterValue(DispatcherParameter.SOAP_ACTION);
            soapAction = soapAction == null ? "" : soapAction;
            headers.removeHeader("Accept");
            headers.addHeader("Accept", "application/soap+xml, application/dime, multipart/related, text/*");
            headers.addHeader("SOAPAction", soapAction);
            SOAPPart soapPart = message.getSOAPPart();
            String msgContent = msg.getPayload().getContent();
            soapPart.setContent((Source)new StreamSource(new StringReader(msgContent)));
            SOAPConnection connection = SOAPConnectionFactory.newInstance().createConnection();
            String url = ((HTTPDevice)this.getDestination()).getUrl();
            logger.debug((Object)("Making SOAP call to " + url));
            SOAPMessage reply = null;
            reply = connection.call(message, (Object)url);
            logger.debug((Object)"successfully called CMS");
            SOAPBody body = reply.getSOAPBody();
            logger.debug((Object)" got reply from CMS");
            if (body.getFault() != null) {
                SOAPFault fault = body.getFault();
                logger.warn((Object)fault.getFaultString());
            }
            response = this.createXMLString((Node)reply.getSOAPPart());
            logger.debug((Object)("responsemessage: " + responseMessage));
            connection.close();
        }
        catch (SOAPException ex) {
            logger.warn((Object)"Soap Exception, kindly ignore.", (Throwable)ex);
            response = "<CMSResponse></CMSResponse>";
        }
        catch (Exception ex) {
            throw new DispatcherException("Could not send xml from SOAP response message.", (Throwable)ex);
        }
        responseMessage = new HTTPMessage(new HTTPPayload(response));
        return responseMessage;
    }

    private String createXMLString(Node xmlNode) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter(1024);
        transformer.transform(new DOMSource(xmlNode), new StreamResult(writer));
        return writer.toString();
    }

    private void buildAttachment(SOAPMessage message, IMessageAttachment messageAttachment) {
        AttachmentPart attachment = message.createAttachmentPart();
        Object content = messageAttachment.getContent();
        String contentType = messageAttachment.getContentType();
        if (content instanceof byte[]) {
            ByteArrayDataSource source = new ByteArrayDataSource(null, contentType, (byte[])content);
            attachment.setDataHandler(new DataHandler((DataSource)source));
        } else {
            attachment.setContent(content, contentType);
        }
        message.addAttachmentPart(attachment);
    }

    private class ByteArrayDataSource
    implements DataSource {
        String contentName;
        String contentType;
        byte[] content;

        ByteArrayDataSource(String name, String contentType, byte[] content) {
            this.contentName = name;
            this.contentType = contentType;
            this.content = content;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.contentName;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new RuntimeException("No Output Stream available for this datasource.");
        }
    }
}

