/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.adaptor;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.TCPMessage;
import com.tandbergtv.workflow.message.TCPPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VTPSPingHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(VTPSPingHandler.class);
    private static final String RESPONSE_TEMPLATE_FILEPATH = "PingResponseTemplateFilePath";
    private static final String COMMAND = "Command";
    private static final String RESPONSE_TYPE = "ResponseType";
    private static final String RESPONSE = "Response";

    public VTPSPingHandler() {
    }

    public VTPSPingHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        TCPMessage result = null;
        logger.debug((Object)("Input Message: " + msg));
        try {
            Document document = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            String commandXPath = this.getConfiguration().getParameterValue(COMMAND);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String strCommand = XMLDocumentUtility.getNodeValue((String)commandXPath, (XPath)xPath, (Node)document);
            result = new TCPMessage(new TCPPayload(strCommand));
            logger.debug((Object)("Processed Message: " + result));
        }
        catch (Exception e) {
            throw new HandlerException("Failed to process message", (Throwable)e);
        }
        return result;
    }

    public IMessage postProcess(IMessage msg) throws HandlerException {
        TCPMessage result = null;
        logger.debug((Object)("Post Processing Message: " + msg));
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            String responseTemplateFileName = this.getConfiguration().getParameterValue(RESPONSE_TEMPLATE_FILEPATH);
            String responseTemplateFilePath = super.getConfigPath() + responseTemplateFileName;
            logger.debug((Object)("response template file path: " + responseTemplateFilePath));
            Document document = XMLDocumentUtility.loadFile((ClassLoader)this.getConfiguration().getClassLoader(), (String)responseTemplateFilePath);
            String responseXPath = this.getConfiguration().getParameterValue(RESPONSE);
            String content = msg.getPayload().getContent();
            XMLDocumentUtility.setNodeValue((String)responseXPath, (String)content, (XPath)xPath, (Node)document);
            String responseTypeXPath = this.getConfiguration().getParameterValue(RESPONSE_TYPE);
            XMLDocumentUtility.setNodeValue((String)responseTypeXPath, (String)WorkflowMessage.MessageType.ack.name(), (XPath)xPath, (Node)document);
            String strXml = XMLDocumentUtility.convertToString((Node)document);
            result = new TCPMessage(new TCPPayload(strXml));
            logger.debug((Object)("Output: " + msg));
        }
        catch (Exception e) {
            throw new HandlerException("Failed to post-process message", (Throwable)e);
        }
        return result;
    }
}

