/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.executionhandlers;

import com.tandbergtv.workflow.plugins.directv.DirecTVConstants;
import com.tandbergtv.workflow.plugins.directv.Extension;
import com.tandbergtv.workflow.plugins.directv.Path;
import com.tandbergtv.workflow.plugins.directv.PathMangler;
import com.tandbergtv.workflow.plugins.directv.Variables;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class AdultMovieVariablesAction
implements ActionHandler {
    private static final String ADULT_MOVIE_QCREQUIRED = "adult.movie.QCRequired";
    private static final String ADULT_HOST = "adult.host";
    private static final String ADULT_MOVIE_VC1_HOUSE = "adult.movie.vc1.house";
    private static final String ADULT_MOVIE_BROADCAST = "adult.movie.broadcast";
    private static final String ADULT_MOVIE_HOUSE = "adult.movie.house";
    private static final String VC1_OUTPUT_FORMAT_VALUE = "ms";
    private static final String VC1_PROFILE_VALUE = "wm9_profile_bb";
    private static final String TYPE_VALUE = "Movie";
    Logger logger = Logger.getLogger(AdultMovieVariablesAction.class);
    private static final long serialVersionUID = -2999994662545067502L;

    public void execute(ExecutionContext context) throws Exception {
        String qcRequired = DirecTVConstants.getString(ADULT_MOVIE_QCREQUIRED);
        context.setVariable(Variables.QCREQUIRED.toString(), (Object)qcRequired);
        context.setVariable(Variables.TYPE.toString(), (Object)TYPE_VALUE);
        String house = DirecTVConstants.getString(ADULT_MOVIE_HOUSE);
        String broadcast = DirecTVConstants.getString(ADULT_MOVIE_BROADCAST);
        String path = (String)context.getVariable(Path.INPUT.toString());
        String extension = FilenameUtils.getExtension((String)path);
        if (((Boolean)context.getVariable(Variables.TARGET_MP2.toString())).booleanValue()) {
            this.setupMPEG2(context, house, broadcast, extension);
        }
        if (((Boolean)context.getVariable(Variables.TARGET_MP4.toString())).booleanValue()) {
            this.setupMPEG4(context, house, broadcast, extension);
        }
        if (((Boolean)context.getVariable(Variables.TARGET_VC1.toString())).booleanValue()) {
            String vc1 = DirecTVConstants.getString(ADULT_MOVIE_VC1_HOUSE);
            this.setupVC1(context, vc1);
        }
        if (((Boolean)context.getVariable(Variables.TARGET_MP4.toString())).booleanValue()) {
            context.setVariable(Variables.HM.toString(), (Object)((String)context.getVariable(Variables.MP4_HMUNC.toString())));
        } else if (((Boolean)context.getVariable(Variables.TARGET_MP2.toString())).booleanValue()) {
            context.setVariable(Variables.HM.toString(), (Object)((String)context.getVariable(Variables.MP2_HM.toString())));
        } else {
            context.setVariable(Variables.HM.toString(), (Object)((String)context.getVariable(Variables.VC1_HF.toString())));
        }
    }

    private void setupMPEG2(ExecutionContext context, String house, String broadcast, String extension) {
        String hid = (String)context.getVariable(Variables.MP2_HM.toString());
        String bid = (String)context.getVariable(Variables.MP2_BM.toString());
        context.setVariable(Path.MP2_HF.toString(), (Object)this.getPath(house, hid + "." + extension));
        context.setVariable(Path.MP2_HF_UNC.toString(), (Object)this.getUNCPath(house, hid + "." + extension));
        context.setVariable(Path.MP2_BF.toString(), (Object)this.getPath(broadcast, bid + "." + (Object)((Object)Extension.ATS)));
        context.setVariable(Path.MP2_MF.toString(), (Object)this.getPath(broadcast, bid + "." + (Object)((Object)Extension.MF)));
    }

    private void setupMPEG4(ExecutionContext context, String house, String broadcast, String extension) {
        String hid = (String)context.getVariable(Variables.MP4_HMUNC.toString());
        String bid = (String)context.getVariable(Variables.MP4_BM.toString());
        context.setVariable(Path.MP4_HF.toString(), (Object)this.getPath(house, hid + "." + extension));
        context.setVariable(Path.MP4_HF_UNC.toString(), (Object)this.getUNCPath(house, hid + "." + extension));
        context.setVariable(Path.MP4_BF.toString(), (Object)this.getPath(broadcast, bid + "." + (Object)((Object)Extension.ATS)));
        context.setVariable(Path.MP4_MF.toString(), (Object)this.getPath(broadcast, bid + "." + (Object)((Object)Extension.MF)));
    }

    private void setupVC1(ExecutionContext context, String house) {
        String hid = (String)context.getVariable(Variables.VC1_HF.toString());
        context.setVariable(Path.VC1_HF.toString(), (Object)this.getPath(house, hid + "." + (Object)((Object)Extension.WMV)));
        context.setVariable(Path.VC1_HF_UNC.toString(), (Object)this.getUNCPath(house, hid + "." + (Object)((Object)Extension.WMV)));
        context.setVariable(Path.VC1_HF_DIR.toString(), (Object)this.getUNCPath(house));
        context.setVariable(Path.VC1_FILE.toString(), (Object)(hid + "." + (Object)((Object)Extension.WMV)));
        context.setVariable(Variables.VC1_OF.toString(), (Object)VC1_OUTPUT_FORMAT_VALUE);
        context.setVariable(Variables.PROFILE.toString(), (Object)VC1_PROFILE_VALUE);
    }

    private String getUNCPath(String path) {
        String host = DirecTVConstants.getString(ADULT_HOST);
        return PathMangler.concatUNC(host, path);
    }

    private String getUNCPath(String path, String filename) {
        String host = DirecTVConstants.getString(ADULT_HOST);
        String unc = PathMangler.concatUNC(host, path, filename);
        return unc;
    }

    private String getPath(String path, String filename) {
        return PathMangler.concat(path, filename);
    }
}

