/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.executionhandlers;

import com.tandbergtv.workflow.executionhandler.handlers.ExecutionHandlerException;
import com.tandbergtv.workflow.plugins.directv.DirecTVConstants;
import com.tandbergtv.workflow.util.FileUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;

public class DiffMetaFileParserEH
implements ActionHandler {
    private static final long serialVersionUID = 9168367546134340150L;
    private static final String ACTION_VARIABLE_NAME = "action";
    private static final String DIFF_FILE_PATH_VAR_NAME = "diffFilePath";
    private static final String META_FILE_PATH_VAR_NAME = "metadataFilePath";
    private static final String MAJOR_CHANGE_ACTION_VALUE_KEY = "DiffMetaFileParserEH.MajorChangeActionValue";
    private static final String MINOR_CHANGE_ACTION_VALUE_KEY = "DiffMetaFileParserEH.MinorChangeActionValue";
    private static final String ALTERED_CHANGE_TYPE_VALUE = "<ALTERED>";
    private static final String ASSET_CLASS_XPATH_PREFIX = "//Metadata/AMS[@Asset_ID='";
    private static final String ASSET_CLASS_XPATH_SUFFIX = "']/@Asset_Class";
    private static final String ASSET_CLASS_VAR_PREFIX = "DiffMetaFileParserEH.";
    private static final String ASSET_CLASS_VAR_SUFFIX = ".MajorChangeAttributes";
    private static final Logger logger = Logger.getLogger(DiffMetaFileParserEH.class);

    public void execute(ExecutionContext ec) throws Exception {
        boolean isMajorChange = false;
        String majorChangeActionValue = this.getConstantValue(MAJOR_CHANGE_ACTION_VALUE_KEY);
        String minorChangeActionValue = this.getConstantValue(MINOR_CHANGE_ACTION_VALUE_KEY);
        ContextInstance ci = ec.getContextInstance();
        String diffFilePath = (String)ec.getVariable(DIFF_FILE_PATH_VAR_NAME);
        if (diffFilePath == null || diffFilePath.trim().length() == 0) {
            isMajorChange = true;
        } else {
            try {
                String contents = FileUtility.readFileContents((String)diffFilePath);
                isMajorChange = this.isMajorChangeInContents(contents, ec);
            }
            catch (ExecutionHandlerException ehe) {
                throw ehe;
            }
            catch (FileNotFoundException fnfe) {
                String msg = "Failed to find the Diff File: " + diffFilePath;
                throw new ExecutionHandlerException(msg, fnfe);
            }
            catch (IOException ioe) {
                String msg = "Failed to read the contents of the Diff File: " + diffFilePath;
                throw new ExecutionHandlerException(msg, ioe);
            }
        }
        String actionValue = isMajorChange ? majorChangeActionValue : minorChangeActionValue;
        ci.setVariable(ACTION_VARIABLE_NAME, (Object)actionValue);
    }

    private boolean isMajorChangeInContents(String contents, ExecutionContext ec) throws ExecutionHandlerException {
        BufferedReader reader = null;
        boolean isMajorChange = false;
        if (contents == null || contents.trim().length() == 0) {
            isMajorChange = true;
            return isMajorChange;
        }
        String diffFilePath = (String)ec.getVariable(DIFF_FILE_PATH_VAR_NAME);
        try {
            reader = new LineNumberReader(new StringReader(contents));
            String line = ((LineNumberReader)reader).readLine();
            boolean ignoreLine = false;
            while (line != null) {
                if (line.trim().length() != 0) {
                    if (!ignoreLine) {
                        String[] tokens = line.trim().split("\\s+");
                        if (tokens.length < 5) {
                            String msg = "Failed to parse MetaData Diff File, line " + ((LineNumberReader)reader).getLineNumber() + ": " + line + " in Meta Diff File: " + diffFilePath + " cannot be parsed.";
                            throw new ExecutionHandlerException(msg);
                        }
                        String assetId = tokens[0];
                        String element = tokens[2];
                        String attribute = tokens[3];
                        String changeType = tokens[4];
                        ignoreLine = changeType.equalsIgnoreCase(ALTERED_CHANGE_TYPE_VALUE);
                        String assetClass = this.getAssetClass(assetId, ec);
                        if (this.isMajorChangeForAssetClass(element, attribute, assetClass, ec)) {
                            isMajorChange = true;
                            break;
                        }
                    } else {
                        ignoreLine = false;
                    }
                }
                line = ((LineNumberReader)reader).readLine();
            }
        }
        catch (IOException ioe) {
            String msg = "Failed to parse the contents of the MetaData Diff File: " + diffFilePath;
            throw new ExecutionHandlerException(msg, ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    logger.warn((Object)("Failed to close reader when parsing Metadata Diff File: " + diffFilePath));
                }
            }
        }
        return isMajorChange;
    }

    private String getConstantValue(String externalKey) throws ExecutionHandlerException {
        try {
            return DirecTVConstants.getString(externalKey);
        }
        catch (Exception ex) {
            String msg = "The Key: " + externalKey + " does not have a value configured in the properties file.";
            throw new ExecutionHandlerException(msg, ex);
        }
    }

    private String getAssetClass(String assetId, ExecutionContext ec) throws ExecutionHandlerException {
        ContextInstance ci = ec.getContextInstance();
        String metaFilePath = (String)ci.getVariable(META_FILE_PATH_VAR_NAME);
        String assetClass = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document metaFileDoc = docBuilder.parse(new File(metaFilePath));
            XPath xpath = XPathFactory.newInstance().newXPath();
            String query = ASSET_CLASS_XPATH_PREFIX + assetId + ASSET_CLASS_XPATH_SUFFIX;
            assetClass = (String)xpath.evaluate(query, metaFileDoc, XPathConstants.STRING);
        }
        catch (Exception ex) {
            String msg = "Failed to load the XML Metadata file: " + metaFilePath + " and determine the Asset class for Asset ID: " + assetId;
            throw new ExecutionHandlerException(msg, ex);
        }
        return assetClass;
    }

    private boolean isMajorChangeForAssetClass(String element, String attribute, String assetClass, ExecutionContext ec) throws ExecutionHandlerException {
        if (assetClass == null || assetClass.length() == 0) {
            return true;
        }
        ContextInstance ci = ec.getContextInstance();
        String diffFilePath = (String)ci.getVariable(DIFF_FILE_PATH_VAR_NAME);
        String key = ASSET_CLASS_VAR_PREFIX + assetClass + ASSET_CLASS_VAR_SUFFIX;
        String value = "";
        try {
            value = DirecTVConstants.getString(key);
        }
        catch (Exception ex) {
            logger.debug((Object)("No configuration of major change attributes for asset class: " + assetClass));
        }
        int startQuoteIndex = attribute.indexOf("'");
        int endQuoteIndex = attribute.lastIndexOf("'");
        if (startQuoteIndex < 0 || startQuoteIndex == endQuoteIndex) {
            String msg = "Failed to parse Attribute: " + attribute + " in Meta Diff file: " + diffFilePath + ", expecting the attribute to be enclosed in single quotes.";
            throw new ExecutionHandlerException(msg);
        }
        String attributeValue = attribute.substring(startQuoteIndex + 1, endQuoteIndex);
        return value.indexOf(attributeValue) >= 0;
    }
}

