/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.executionhandlers;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.executionhandler.handlers.ExecutionHandlerException;
import com.tandbergtv.workflow.plugins.directv.DirecTVConstants;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ExtractContentTypeEH
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(ExtractContentTypeEH.class);
    private static final long serialVersionUID = 1503153472686201760L;
    private static final String ADULT_TEMPLATE_LIST_KEY = "ExtractContentTypeEH.AdultTemplateList";
    private static final String NON_ADULT_TEMPLATE_LIST_KEY = "ExtractContentTypeEH.NonAdultTemplateList";
    private static final String PROCESS_DEFINITION_SEARCH_KEY = "processDefinition.name";
    private static final String PROVIDER_ID_VAR_NAME = "providerId";
    private static final String PACKAGE_ASSET_ID_VAR_NAME = "packageAssetId";
    private static final String ASSET_ID_VAR_NAME = "assetId";
    private static final String CONTENT_TYPE_VAR_NAME = "contentType";
    private static final String ADULT_CONTENT_VAR_NAME = "isAdultContent";
    private static final String START_DATE_COLUMN = "start";
    private static final String ROWAD_CONTENT_TYPE_KEY = "ExtractContentTypeEH.RowAdContentType";
    private static final String HOMEPAGE_CONTENT_TYPE_KEY = "ExtractContentTypeEH.HomePageContentType";
    private static final String MOBILE_CONTENT_TYPE_KEY = "ExtractContentTypeEH.MobileContentType";
    private static final String ROWAD_ASSET_ID_VAR_NAMES_KEY = "ExtractContentTypeEH.RowAdAssetIdVariables";
    private static final String HOMEPAGE_ASSET_ID_VAR_NAMES_KEY = "ExtractContentTypeEH.HomePageAssetIdVariables";
    private static final String MOBILE_ASSET_ID_VAR_NAMES_KEY = "ExtractContentTypeEH.MobileAssetIdVariables";
    private static final String SOURCE_VAR_KEY_SUFFIX = ".SourceVarNames";
    private static final String DEST_VAR_KEY_SUFFIX = ".DestVarNames";

    public void execute(ExecutionContext ec) throws Exception {
        List<String> adultTemplateList = this.getConstantValueList(ADULT_TEMPLATE_LIST_KEY);
        List<String> nonAdultTemplateList = this.getConstantValueList(NON_ADULT_TEMPLATE_LIST_KEY);
        if (adultTemplateList.size() == 0 && nonAdultTemplateList.size() == 0) {
            String msg = "The values configured for keys: ExtractContentTypeEH.AdultTemplateList and ExtractContentTypeEH.NonAdultTemplateList are invalid, at least one template name must be specified.";
            throw new ExecutionHandlerException(msg);
        }
        ContextInstance contextInstance = ec.getContextInstance();
        WorkflowProcess aasProcess = this.findAssetArrivalSuccessProcess(contextInstance, adultTemplateList, nonAdultTemplateList);
        this.setAdultFlag(contextInstance, aasProcess, adultTemplateList, nonAdultTemplateList);
        this.copyVariables(contextInstance, aasProcess);
    }

    private WorkflowProcess findAssetArrivalSuccessProcess(ContextInstance contextInstance, List<String> adultTemplateList, List<String> nonAdultTemplateList) {
        SearchCriteria criteria = new SearchCriteria();
        ListParameter templateNameParameters = new ListParameter(PROCESS_DEFINITION_SEARCH_KEY);
        for (String templateName : adultTemplateList) {
            templateNameParameters.addValue((Object)templateName);
        }
        for (String templateName : nonAdultTemplateList) {
            templateNameParameters.addValue((Object)templateName);
        }
        criteria.addParameter((SearchParameterBase)templateNameParameters);
        String packageAssetId = (String)contextInstance.getVariable(PACKAGE_ASSET_ID_VAR_NAME);
        String providerId = (String)contextInstance.getVariable(PROVIDER_ID_VAR_NAME);
        ValueParameter parameter = new ValueParameter(PACKAGE_ASSET_ID_VAR_NAME, SearchType.STRING, true);
        parameter.setValue((Object)packageAssetId);
        criteria.addParameter((SearchParameterBase)parameter);
        parameter = new ValueParameter(PROVIDER_ID_VAR_NAME, SearchType.STRING, true);
        parameter.setValue((Object)providerId);
        criteria.addParameter((SearchParameterBase)parameter);
        parameter = new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)ProcessStatus.COMPLETED);
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.addParameter((SearchParameterBase)new SortParameter(START_DATE_COLUMN, SortingOrder.DESCENDING));
        ServiceRegistry registry = ServiceRegistry.getDefault();
        List processList = ((IProcessSearchService)registry.lookup(IProcessSearchService.class)).search(criteria);
        if (processList == null || processList.size() == 0) {
            String msg = "Failed to find the completed 'Asset Arrival Success' Work Order with ProviderId: " + providerId + ", PackageAssetId: " + packageAssetId + ".";
            throw new ExecutionHandlerException(msg);
        }
        logger.debug((Object)("Found Asset Arrival Process: " + ((WorkflowProcess)processList.get(0)).getId()));
        return (WorkflowProcess)processList.get(0);
    }

    private void setAdultFlag(ContextInstance contextInstance, WorkflowProcess process, List<String> adultTemplates, List<String> nonAdultTemplates) {
        String isAdult = null;
        String definitionName = process.getProcessDefinition().getName();
        if (adultTemplates.contains(definitionName)) {
            isAdult = Boolean.toString(true);
        } else if (nonAdultTemplates.contains(definitionName)) {
            isAdult = Boolean.toString(false);
        } else {
            String msg = "Failed to find Work Order for which the template matches the  configured Adult or Non-Adult Asset Arrival Success Templates.";
            throw new ExecutionHandlerException(msg);
        }
        contextInstance.setVariable(ADULT_CONTENT_VAR_NAME, (Object)isAdult);
    }

    private void copyVariables(ContextInstance contextInstance, WorkflowProcess process) {
        String contentType = (String)contextInstance.getVariable(CONTENT_TYPE_VAR_NAME);
        String rowadTypeValue = this.getConstantValue(ROWAD_CONTENT_TYPE_KEY);
        String homepageTypeValue = this.getConstantValue(HOMEPAGE_CONTENT_TYPE_KEY);
        String mobileTypeValue = this.getConstantValue(MOBILE_CONTENT_TYPE_KEY);
        List<String> assetIdVarList = null;
        if (contentType != null && contentType.equals(rowadTypeValue)) {
            assetIdVarList = this.getConstantValueList(ROWAD_ASSET_ID_VAR_NAMES_KEY);
        } else if (contentType != null && contentType.equals(homepageTypeValue)) {
            assetIdVarList = this.getConstantValueList(HOMEPAGE_ASSET_ID_VAR_NAMES_KEY);
        } else if (contentType != null && contentType.equals(mobileTypeValue)) {
            assetIdVarList = this.getConstantValueList(MOBILE_ASSET_ID_VAR_NAMES_KEY);
        }
        if (assetIdVarList == null) {
            return;
        }
        String assetId = (String)contextInstance.getVariable(ASSET_ID_VAR_NAME);
        ContextInstance aasContextInstance = process.getContextInstance();
        String matchingAssetIdVar = null;
        for (String assetIdVar : assetIdVarList) {
            Object value = aasContextInstance.getVariable(assetIdVar);
            if (value == null || !value.equals(assetId)) continue;
            matchingAssetIdVar = assetIdVar;
            break;
        }
        if (matchingAssetIdVar == null) {
            String msg = "Failed to find Asset Id: '" + assetId + "' in Work Order[" + process.getId() + "]: " + process.getProcessDefinition().getName();
            throw new ExecutionHandlerException(msg);
        }
        String copyVarSrcKey = matchingAssetIdVar + SOURCE_VAR_KEY_SUFFIX;
        String copyVarDestKey = matchingAssetIdVar + DEST_VAR_KEY_SUFFIX;
        List<String> sourceVars = this.getConstantValueList(copyVarSrcKey);
        List<String> destVars = this.getConstantValueList(copyVarDestKey);
        if (sourceVars.size() != destVars.size()) {
            String msg = "Asset Id variable: " + matchingAssetIdVar + " matched for Asset Id: " + assetId + " does not have an equal number of 'SourceVarNames' and " + "'DestVarNames' specified for variable copying.";
            throw new ExecutionHandlerException(msg);
        }
        for (int i = 0; i < sourceVars.size(); ++i) {
            String sourceVar = sourceVars.get(i);
            String destVar = destVars.get(i);
            Object value = aasContextInstance.getVariable(sourceVar);
            contextInstance.setVariable(destVar, value);
            logger.debug((Object)("Source Var: Name: " + sourceVar + " | Value: " + value));
            logger.debug((Object)("Dest Var: Name: " + destVar + " | Value: " + contextInstance.getVariable(destVar)));
        }
    }

    private List<String> getConstantValueList(String externalKey) throws ExecutionHandlerException {
        String[] values;
        ArrayList<String> valueList = new ArrayList<String>();
        String csvString = DirecTVConstants.getString(externalKey);
        if (csvString == null) {
            csvString = "";
        }
        for (String value : values = csvString.split(",")) {
            String string = value = value != null ? value.trim() : "";
            if (value.length() <= 0) continue;
            valueList.add(value);
        }
        return valueList;
    }

    private String getConstantValue(String key) {
        String value = DirecTVConstants.getString(key);
        if (value == null) {
            value = "";
        }
        return value;
    }
}

