/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.executionhandlers;

import com.tandbergtv.workflow.plugins.directv.DirecTVConstants;
import com.tandbergtv.workflow.plugins.directv.PathMangler;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class RowAdAction
implements ActionHandler {
    private static final String FORMAT_EXTENSION = ".png";
    private static final String BROADCAST_FORMAT_PATH_UNC = "broadcastFormatPathUNC";
    private static final String HOUSE_FORMAT_PATH_UNC = "houseFormatPathUNC";
    private static final String BROADCAST_FORMAT_PATH = "broadcastFormatPath";
    private static final String HOUSE_FORMAT_PATH = "houseFormatPath";
    private static final String BROADCAST = "rowad.broadcast";
    private static final String HOUSE = "rowad.house";
    private static final String HOUSE_MATERIAL_ID = "houseMaterialId";
    private static final long serialVersionUID = -8905425688092045158L;

    public void execute(ExecutionContext context) throws Exception {
        String houseMaterialId = (String)context.getVariable(HOUSE_MATERIAL_ID);
        String filename = houseMaterialId + FORMAT_EXTENSION;
        String house = DirecTVConstants.getString(HOUSE);
        String broadcast = DirecTVConstants.getString(BROADCAST);
        context.setVariable(HOUSE_FORMAT_PATH, (Object)this.getPath(house, filename));
        context.setVariable(BROADCAST_FORMAT_PATH, (Object)this.getPath(broadcast, filename));
        context.setVariable(HOUSE_FORMAT_PATH_UNC, (Object)this.getUNCPath(house, filename));
        context.setVariable(BROADCAST_FORMAT_PATH_UNC, (Object)this.getUNCPath(broadcast, filename));
        context.setVariable("type", (Object)"RowAd");
        context.setVariable("duration", (Object)"0");
    }

    private String getUNCPath(String path, String filename) {
        String host = DirecTVConstants.getString("host");
        return PathMangler.concatUNC(host, path, filename);
    }

    private String getPath(String path, String filename) {
        return PathMangler.concat(path, filename);
    }
}

