/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.executionhandler.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WorkOrderCreatorConfigReader {
    private static final String VARIABLE = "variable";
    private static final String VARIABLE_NAME = "name";
    private static final String VARIABLE_MAPPED_NAME = "mappedName";
    private static final String CONSTANT = "constant";
    private static final String CONSTANT_NAME = "name";
    private static final String CONSTANT_VALUE = "value";
    private static WorkOrderCreatorConfigReader _instance;
    private Map<String, Configuration> fileNameToConfigMap = new HashMap<String, Configuration>();

    private WorkOrderCreatorConfigReader() {
    }

    public static synchronized WorkOrderCreatorConfigReader getInstance() {
        if (_instance == null) {
            _instance = new WorkOrderCreatorConfigReader();
        }
        return _instance;
    }

    public Map<String, String> getConstants(String configFileName) throws Exception {
        this.updateCacheIfNecessary(configFileName);
        return this.fileNameToConfigMap.get((Object)configFileName).constants;
    }

    public Map<String, String> getVariables(String configFileName) throws Exception {
        this.updateCacheIfNecessary(configFileName);
        return this.fileNameToConfigMap.get((Object)configFileName).variables;
    }

    private void updateCacheIfNecessary(String configFileName) throws Exception {
        if (!this.fileNameToConfigMap.containsKey(configFileName)) {
            this.fileNameToConfigMap.put(configFileName, this.readConfigFile(configFileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration readConfigFile(String configFileName) throws IOException, SAXException, ParserConfigurationException {
        Configuration conf = new Configuration();
        InputStream configFileInputStream = null;
        try {
            configFileInputStream = this.getClass().getClassLoader().getResourceAsStream(configFileName);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(configFileInputStream);
            NodeList variableNodeList = document.getDocumentElement().getElementsByTagName(VARIABLE);
            for (int i = 0; i < variableNodeList.getLength(); ++i) {
                Node variableNode = variableNodeList.item(i);
                String variableName = this.getTextContentOfChildNode(variableNode, "name");
                String variableMappedName = this.getTextContentOfChildNode(variableNode, VARIABLE_MAPPED_NAME);
                conf.addVariable(variableName, variableMappedName);
            }
            NodeList constantNodeList = document.getDocumentElement().getElementsByTagName(CONSTANT);
            for (int i = 0; i < constantNodeList.getLength(); ++i) {
                Node constantNode = constantNodeList.item(i);
                String constantName = this.getTextContentOfChildNode(constantNode, "name");
                String constantValue = this.getTextContentOfChildNode(constantNode, CONSTANT_VALUE);
                conf.addConstant(constantName, constantValue);
            }
        }
        finally {
            try {
                if (configFileInputStream != null) {
                    configFileInputStream.close();
                }
            }
            catch (Exception e) {}
        }
        return conf;
    }

    private String getTextContentOfChildNode(Node parentNode, String childNodeName) {
        NodeList childNodeList = parentNode.getChildNodes();
        if (childNodeList != null) {
            for (int i = 0; i < childNodeList.getLength(); ++i) {
                Node childNode = childNodeList.item(i);
                if (!childNode.getNodeName().equals(childNodeName)) continue;
                return childNode.getTextContent().trim();
            }
        }
        return null;
    }

    private static class Configuration {
        Map<String, String> constants;
        Map<String, String> variables;

        private Configuration() {
        }

        void addVariable(String variableName, String variableMappedName) {
            if (this.variables == null) {
                this.variables = new HashMap<String, String>();
            }
            this.variables.put(variableName, variableMappedName);
        }

        void addConstant(String name, String value) {
            if (this.constants == null) {
                this.constants = new HashMap<String, String>();
            }
            this.constants.put(name, value);
        }
    }
}

