/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.executionhandlers;

import com.tandbergtv.workflow.plugins.directv.Path;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetEncoderProfileFromMetadataAction
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT_XPATH = "//App_Data[@Name='format']";
    private static final String APP_DATA_VALUE = "Value";
    private static final String ASSET_CLASS_XPATH = "//Asset/Asset/Metadata/AMS";
    private static final String ASSET_CLASS = "Asset_Class";
    private static final Logger logger = Logger.getLogger(GetEncoderProfileFromMetadataAction.class);

    public void execute(ExecutionContext ec) throws Exception {
        String contentPath = (String)ec.getVariable(Path.INPUT.toString());
        String dirPath = contentPath.substring(0, contentPath.lastIndexOf(File.separator));
        logger.debug((Object)("contentPath=" + contentPath + ", dirPath=" + dirPath));
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        String metadataPath = null;
        if (files != null) {
            for (File f : files) {
                if (!f.getName().toLowerCase().endsWith("xml")) continue;
                metadataPath = f.getAbsolutePath();
                logger.debug((Object)("Metadata file path = " + metadataPath));
                break;
            }
        }
        if (metadataPath != null) {
            File metadataFile = new File(metadataPath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(metadataFile);
            NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate(ASSET_CLASS_XPATH, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!node.getAttributes().getNamedItem(ASSET_CLASS).getTextContent().equals("movie")) continue;
                String format = this.getFormat(document);
                if (format != null) {
                    ec.setVariable("format", (Object)format);
                }
                logger.debug((Object)("format=" + format));
                break;
            }
        }
    }

    private String getFormat(Document document) throws Exception {
        return this.getAttributeValue(FORMAT_XPATH, APP_DATA_VALUE, document);
    }

    private String getAttributeValue(String expression, String attribute, Document document) throws Exception {
        Node node = (Node)XPathFactory.newInstance().newXPath().evaluate(expression, document, XPathConstants.NODE);
        if (node != null) {
            return node.getAttributes().getNamedItem(attribute).getTextContent();
        }
        return null;
    }
}

