/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.plugins;

import com.n2bb.web.help.HelpBean;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public final class HelpPlugIn
implements PlugIn {
    private Log n2bbLog = LogFactory.getLog(HelpPlugIn.class);
    private ActionServlet servlet = null;
    private String helpBase = "/help/";

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.n2bbLog.debug((Object)"enter");
        this.servlet = servlet;
        Map<String, HelpBean> products = Collections.synchronizedMap(new TreeMap());
        Set helpPaths = servlet.getServletContext().getResourcePaths(this.helpBase);
        for (String path : helpPaths) {
            if (!path.endsWith("/")) continue;
            try {
                Properties props = new Properties();
                InputStream is = servlet.getServletContext().getResourceAsStream(String.valueOf(path) + "product.properties");
                if (is == null) {
                    this.n2bbLog.error((Object)("no product.properties file under... " + path + " - skipping directory"));
                    continue;
                }
                try {
                    props.load(is);
                }
                catch (Exception e) {
                    this.n2bbLog.warn((Object)("failed to load product.properties - message... " + e.getMessage()), (Throwable)e);
                }
                String version = this.parseVersion(props.getProperty("version"));
                HelpBean bean = new HelpBean(props.getProperty("name"), version);
                this.n2bbLog.info((Object)("product name... " + bean.getName()));
                this.n2bbLog.info((Object)("path... " + path));
                Set helpFiles = servlet.getServletContext().getResourcePaths(path);
                for (String file : helpFiles) {
                    if (file.indexOf("product.properties") != -1) continue;
                    this.n2bbLog.info((Object)("help file... " + file));
                    bean.addDoc(file);
                }
                products.put(bean.getName(), bean);
            }
            catch (Exception e) {
                this.n2bbLog.warn((Object)("error initializing help for path... " + path + " - message... " + e.getMessage()), (Throwable)e);
            }
        }
        servlet.getServletContext().setAttribute("helpDocs", products);
    }

    private String parseVersion(String version) {
        try {
            if (version == null) {
                return version;
            }
            int end = 0;
            int dot = 0;
            int i = 0;
            while (i <= 2) {
                if ((dot = version.indexOf(46, dot)) == -1) {
                    end = version.length();
                    break;
                }
                end = dot++;
                ++i;
            }
            version = version.substring(0, end);
            this.n2bbLog.debug((Object)("version... " + version));
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
        }
        return version;
    }

    public void destroy() {
        this.servlet.getServletContext().removeAttribute("helpDocs");
    }
}

