/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.plugins;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MenuPlugIn
implements PlugIn {
    private Log n2bbLog = LogFactory.getLog((String)"n2bbLog");
    private ActionServlet servlet = null;
    private String menuConfig;
    private List menuNames = new ArrayList();
    private String menuName = "";
    private String mastheadImage;

    public String getMenuConfig() {
        return this.menuConfig;
    }

    public void setMenuConfig(String menuConfig) {
        this.menuConfig = menuConfig;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public String getMastheadImage() {
        return this.mastheadImage;
    }

    public void setMastheadImage(String mastheadImage) {
        this.mastheadImage = mastheadImage;
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.n2bbLog.debug((Object)"enter");
        this.servlet = servlet;
        if (this.menuConfig == null) {
            this.menuConfig = servlet.getServletConfig().getInitParameter("menuConfig");
        }
        ServletContext servletContext = servlet.getServletContext();
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            InputStream is = servletContext.getResourceAsStream(this.menuConfig);
            Document menuDoc = domBuilder.parse(is);
            Map topMenuMap = this.findOrCreateMap(servletContext, "topMenuMap");
            topMenuMap.put(this.menuName, this.getTopMenu(menuDoc));
            Map bottomMenuMap = this.findOrCreateMap(servletContext, "bottomMenuMap");
            bottomMenuMap.put(this.menuName, this.getBtmMenu(menuDoc));
            if (this.mastheadImage != null) {
                Map mastheadImages = this.findOrCreateMap(servletContext, "mastheadImageMap");
                mastheadImages.put(this.menuName, this.mastheadImage);
            }
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)("failed to load menu - message... " + e.getMessage()), (Throwable)e);
        }
    }

    private Map findOrCreateMap(ServletContext servletContext, String mapName) {
        HashMap map = (HashMap)servletContext.getAttribute(mapName);
        if (map == null) {
            map = new HashMap();
            servletContext.setAttribute(mapName, map);
        }
        return map;
    }

    private String getTopMenu(Document menuDoc) {
        Node menuNode = menuDoc.getFirstChild();
        NodeList list = menuNode.getChildNodes();
        return this.getMainMenuItems(list);
    }

    private String getBtmMenu(Document menuDoc) {
        Node menuNode = menuDoc.getFirstChild();
        NodeList list = menuNode.getChildNodes();
        return String.valueOf(this.getSubMenuBarOpener()) + this.getSubMenus(list) + this.getCloser() + this.getInitScript();
    }

    private String quoted(String text) {
        return "'" + text + "'";
    }

    private String getMainMenuItems(NodeList list) {
        String mainMenuItems = "";
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeName().equals("menuItem")) {
                String id = ((Element)node).getAttribute("id");
                String display = ((Element)node).getAttribute("display");
                String path = ((Element)node).getAttribute("path");
                mainMenuItems = String.valueOf(mainMenuItems) + this.getMainMenuItem(id, display, path);
                this.menuNames.add(id);
            }
            ++i;
        }
        return mainMenuItems;
    }

    private String getMainMenuItem(String menuName, String display, String path) {
        return "        <td id=" + this.quoted(String.valueOf(menuName) + "MainMenu") + ">\n" + this.mainMenuLink(path, display) + "        </td>\n";
    }

    private String mainMenuLink(String path, String display) {
        return "            <a href=" + this.quoted(path) + " target='_top'>&gt; " + display + "</a>\n";
    }

    private String subMenuLink(String path, String display) {
        return "            <a href=" + this.quoted(path) + " target='_top'>" + display + "</a>\n";
    }

    private String getMainMenuCloser() {
        return "        <td style=" + this.quoted("width: 99%") + ">&nbsp;</td>\n" + "    </tr>\n</table>\n";
    }

    private String getSubMenuBarOpener() {
        return "<div id=" + this.quoted("subMenuBar") + ">\n";
    }

    private String getSubMenus(NodeList list) {
        String subMenus = "";
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeName().equals("menuItem")) {
                String id = ((Element)node).getAttribute("id");
                NodeList subList = node.getChildNodes();
                if (subList.getLength() != 0) {
                    subMenus = String.valueOf(subMenus) + this.getSubMenuOpener(id);
                    int j = 0;
                    while (j < subList.getLength()) {
                        Node subNode = subList.item(j);
                        if (subNode.getNodeName().equals("menuItem")) {
                            String display = ((Element)subNode).getAttribute("display");
                            String path = ((Element)subNode).getAttribute("path");
                            subMenus = String.valueOf(subMenus) + this.getSubMenuItem(display, path);
                        }
                        ++j;
                    }
                    subMenus = String.valueOf(subMenus) + this.getSubMenuCloser();
                }
            }
            ++i;
        }
        return subMenus;
    }

    private String getSubMenuOpener(String menuName) {
        return "<div id=" + this.quoted(String.valueOf(menuName) + "SubMenu") + " style=" + this.quoted("display: none; position: relative") + ">\n" + "<table class=" + this.quoted("sub-menu") + ">\n" + "    <tr>\n";
    }

    private String getSubMenuItem(String display, String path) {
        return "        <td>\n" + this.subMenuLink(path, display) + "        </td>\n";
    }

    private String getSubMenuCloser() {
        return "    </tr>\n</table>\n</div>\n";
    }

    private String getCloser() {
        return "</div>\n";
    }

    private String getInitScript() {
        String script = "<script>\nvar menuNames = new Array(";
        Iterator iterator = this.menuNames.iterator();
        while (iterator.hasNext()) {
            String menuName = (String)iterator.next();
            script = String.valueOf(script) + this.quoted(menuName) + (iterator.hasNext() ? ", " : "");
        }
        script = String.valueOf(script) + ");\nfunction initAlignMenu() {\n    alignMenu = new AlignMenu(menuNames);\n}\n</script>\n";
        return script;
    }

    public void destroy() {
        this.servlet.getServletContext().removeAttribute("topMenuMap");
        this.servlet.getServletContext().removeAttribute("bottomMenuMap");
        this.servlet.getServletContext().removeAttribute("mastheadImageMap");
    }
}

