/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.plugins;

import com.n2bb.security.SecurityManager;
import com.n2bb.util.N2bbSettings;
import com.n2bb.util.PropertyManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public final class N2BBPlugIn
implements PlugIn {
    private Log n2bbLog = LogFactory.getLog(N2BBPlugIn.class);
    private ActionServlet servlet = null;
    private String appPopupPath = "/WEB-INF/appPopups";
    private String securityPath = "/WEB-INF/security";

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        PropertyManager propertyManager = PropertyManager.getInstance();
        int ps = propertyManager.getInteger("PAGE_SIZE", 10);
        N2bbSettings.PAGE_SIZE = ps < 1 ? 10 : ps;
        this.n2bbLog.info((Object)("page size... " + N2bbSettings.PAGE_SIZE));
        String siteLocation = propertyManager.getValue("SITE_LOCATION", "Default Site Name");
        if (siteLocation.length() > 30) {
            siteLocation = siteLocation.substring(0, 30);
        }
        ServletContext servletContext = servlet.getServletContext();
        servletContext.setAttribute("siteLocation", (Object)siteLocation);
        servletContext.setAttribute("showUser", (Object)propertyManager.getValue("SHOW_USER", "true"));
        servletContext.setAttribute("showDate", (Object)propertyManager.getValue("SHOW_DATE", "true"));
        SecurityManager.init(servletContext, this.securityPath);
    }

    public void destroy() {
        this.servlet.getServletContext().removeAttribute("siteLocation");
        this.servlet.getServletContext().removeAttribute("appPopup");
        this.servlet.getServletContext().removeAttribute("dashboard");
        SecurityManager.destroy();
    }
}

