/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.sysmonui.alerts;

import com.n2bb.action.N2bbAction;
import com.n2bb.sysmonui.alerts.AlertDataBean;
import com.n2bb.sysmonui.alerts.AlertForm;
import com.n2bb.sysmonui.alerts.AlertManager;
import com.n2bb.util.N2bbException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class AlertAction
extends N2bbAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String defaultAction = "add";
        HttpSession session = request.getSession();
        String action = request.getParameter("actionType");
        if (action == null || action.equals("")) {
            action = defaultAction;
        }
        this.n2bbLog.debug((Object)("action... " + action));
        ActionErrors errors = new ActionErrors();
        ActionForward fwd = mapping.findForward("home");
        try {
            if (action.equals("add")) {
                fwd = this.addAlert(errors, session) ? mapping.findForward("success") : mapping.findForward("failure");
            } else if (action.equals("save")) {
                fwd = this.saveAlert(errors, form) ? mapping.findForward("success") : mapping.findForward("failure");
            } else if (action.equals("edit")) {
                fwd = this.editAlert(errors, session, request) ? mapping.findForward("success") : mapping.findForward("failure");
            } else if (action.equals("update")) {
                fwd = this.updateAlert(errors, form) ? mapping.findForward("success") : mapping.findForward("failure");
            }
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
        }
        return fwd;
    }

    private boolean addAlert(ActionErrors errors, HttpSession session) {
        this.n2bbLog.debug((Object)"enter");
        try {
            session.setAttribute("alertNameMap", (Object)AlertManager.getAlertPatternMap());
            return true;
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.alertAction.add"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.other"));
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean saveAlert(ActionErrors errors, ActionForm form) {
        try {
            AlertDataBean bean = this.convertFormToBean((AlertForm)form);
            AlertManager.saveAlert(bean);
            return true;
        }
        catch (N2bbException e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.alertAction.save"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
            this.n2bbLog.error((Object)("failed to save - message... " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean editAlert(ActionErrors errors, HttpSession session, HttpServletRequest request) {
        try {
            request.setAttribute("TabbedAlertsModify", (Object)"TabbedAlertsModify");
            session.setAttribute("alertNameMap", (Object)AlertManager.getAlertPatternMap());
        }
        catch (N2bbException e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.alertAction.edit"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.alertAction.names"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
            return false;
        }
        try {
            String alertIdentifier = request.getParameter("alertIdentifier");
            AlertDataBean bean = AlertManager.getAlert(alertIdentifier);
            AlertForm form = this.convertBeanToForm(bean);
            form.setAction("edit");
            request.setAttribute("alertForm", (Object)form);
        }
        catch (N2bbException e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.alertAction.edit"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
            this.n2bbLog.error((Object)("failed to get alert exception - message... " + e.getMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean updateAlert(ActionErrors errors, ActionForm form) {
        try {
            AlertDataBean bean = this.convertFormToBean((AlertForm)form);
            AlertManager.updateAlert(bean);
        }
        catch (N2bbException e) {
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.alertAction.update"));
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
            this.n2bbLog.error((Object)("failed to update - message... " + e.getMessage()), (Throwable)e);
            return false;
        }
        return true;
    }

    private AlertDataBean convertFormToBean(AlertForm form) {
        int tc;
        int fc;
        AlertDataBean bean = new AlertDataBean();
        bean.setAlertIdentifier(form.getAlertIdentifier());
        bean.setAlertPattern(form.getAlertPattern());
        try {
            fc = Integer.parseInt(form.getFrequencyCount());
        }
        catch (Exception e) {
            fc = 1;
        }
        bean.setFrequencyCount(fc);
        int fhr = 0;
        int fmin = 0;
        int fsec = 0;
        int ftot = 0;
        try {
            fhr = Integer.parseInt(form.getFrequencyHr()) * 3600;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fmin = Integer.parseInt(form.getFrequencyMin()) * 60;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fsec = Integer.parseInt(form.getFrequencySec());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ftot = fhr + fmin + fsec;
        bean.setFrequencySecs(ftot);
        try {
            tc = Integer.parseInt(form.getThresholdCount());
        }
        catch (Exception e) {
            tc = 1;
        }
        bean.setThresholdCount(tc);
        int thr = 0;
        int tmin = 0;
        int tsec = 0;
        int ttot = 0;
        try {
            thr = Integer.parseInt(form.getThresholdHr()) * 3600;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tmin = Integer.parseInt(form.getThresholdMin()) * 60;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tsec = Integer.parseInt(form.getThresholdSec());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ttot = thr + tmin + tsec;
        bean.setThresholdSecs(ttot);
        if (form.getChkEmail()) {
            bean.setEmail(form.getTxtEmail());
        }
        if (form.getChkSnmp()) {
            bean.setSNMP(form.getTxtSnmp());
        }
        return bean;
    }

    private AlertForm convertBeanToForm(AlertDataBean bean) {
        AlertForm form = new AlertForm();
        form.setAlertIdentifier(bean.getAlertIdentifier());
        form.setAlertPattern(bean.getAlertPattern());
        form.setFrequencyCount(String.valueOf(bean.getFrequencyCount()));
        int fseconds = 0;
        int fminutes = 0;
        int fhours = 0;
        fhours = bean.getFrequencySecs() / 3600;
        int fsecsLeft = bean.getFrequencySecs() % 3600;
        if (fsecsLeft != 0) {
            if (fsecsLeft > 59) {
                fminutes = fsecsLeft / 60;
                fseconds = fsecsLeft % 60;
            } else {
                fseconds = fsecsLeft;
            }
        }
        form.setFrequencyHr(String.valueOf(fhours));
        form.setFrequencyMin(String.valueOf(fminutes));
        form.setFrequencySec(String.valueOf(fseconds));
        form.setThresholdCount(String.valueOf(bean.getThresholdCount()));
        int tseconds = 0;
        int tminutes = 0;
        int thours = 0;
        thours = bean.getThresholdSecs() / 3600;
        int tsecsLeft = bean.getThresholdSecs() % 3600;
        if (tsecsLeft != 0) {
            if (tsecsLeft > 59) {
                tminutes = tsecsLeft / 60;
                tseconds = tsecsLeft % 60;
            } else {
                tseconds = tsecsLeft;
            }
        }
        form.setThresholdHr(String.valueOf(thours));
        form.setThresholdMin(String.valueOf(tminutes));
        form.setThresholdSec(String.valueOf(tseconds));
        if (!bean.getEmail().equals("")) {
            form.setChkEmail(true);
            form.setTxtEmail(bean.getEmail());
        }
        if (!bean.getSNMP().equals("")) {
            form.setChkSnmp(true);
            form.setTxtSnmp(bean.getSNMP());
        }
        return form;
    }
}

