/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.user;

import com.n2bb.action.AbstractAction;
import com.n2bb.user.UserManager;
import com.n2bb.util.N2bbException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ModifyUsersAction
extends AbstractAction {
    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] ids;
        ArrayList<String> unChangedUsers = new ArrayList<String>();
        ActionErrors errors = new ActionErrors();
        log.debug((Object)"enter");
        String method = request.getParameter("methodName");
        if (method == null) {
            method = "";
        }
        if ((ids = request.getParameterValues("ids")) != null) {
            if (method.equals("delete")) {
                this.delete(ids, errors, unChangedUsers);
                log.debug((Object)("Undeleted users size-->" + unChangedUsers.size()));
                if (unChangedUsers.size() > 0) {
                    request.setAttribute("UnDeletedUsers", unChangedUsers);
                }
            } else if (method.equals("changeState")) {
                this.changeState(ids, errors, unChangedUsers);
                log.debug((Object)("Unchanged users size-->" + unChangedUsers.size()));
                if (unChangedUsers.size() > 0) {
                    request.setAttribute("UnChangedUsers", unChangedUsers);
                }
            }
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return mapping.findForward("success");
    }

    private void delete(String[] ids, ActionErrors errors, List<String> unDeletedUsers) {
        int i = 0;
        while (i < ids.length) {
            String userName = ids[i];
            log.debug((Object)("name... " + userName));
            if (!userName.equalsIgnoreCase("admin")) {
                try {
                    ResourceManagement resourceManagement = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
                    if (resourceManagement.getResourceByUser(userName) == null) {
                        UserManager.getInstance().deleteUser(userName);
                    } else {
                        unDeletedUsers.add(userName);
                    }
                }
                catch (N2bbException e) {
                    errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.listUsersAction.delete", (Object)userName));
                }
            }
            ++i;
        }
    }

    private void changeState(String[] ids, ActionErrors errors, List<String> unChangedUsers) {
        int i = 0;
        while (i < ids.length) {
            String userName = ids[i];
            log.debug((Object)("name... " + userName));
            if (!userName.equalsIgnoreCase("admin")) {
                try {
                    ResourceManagement resourceManagement = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
                    Resource resource = resourceManagement.getResourceByUser(userName);
                    if (resource != null && (resource.getAdministrationState() != ResourceState.OFFLINE || resource.getOperationalState() != ResourceState.INVALID && resource.getOperationalState() != ResourceState.INACTIVE && resource.getOperationalState() != ResourceState.OFFLINE)) {
                        unChangedUsers.add(userName);
                    } else {
                        UserManager.getInstance().toggleUserStatus(userName);
                    }
                }
                catch (N2bbException e) {
                    errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.listUsersAction.changeStatus", (Object)userName));
                    errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(e.getErrorCode()));
                }
            }
            ++i;
        }
    }
}

