/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static DateFormat getLongYearDateFormat(Locale locale) {
        return DateUtil.getLongYearDateFormat(locale, false);
    }

    public static DateFormat getLongYearDateFormat(Locale locale, boolean time) {
        DateFormat dateFormat;
        DateFormat dateFormat2 = dateFormat = time ? DateFormat.getDateTimeInstance(3, 3, locale) : DateFormat.getDateInstance(3, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)dateFormat).toPattern();
            pattern = pattern.replaceFirst("y+", "yyyy");
            dateFormat = new SimpleDateFormat(pattern, locale);
        }
        return dateFormat;
    }

    public static Date getCurrentCenturyDate(Locale locale, String dateString, int currentCenturyStartYear) throws ParseException {
        Calendar cal = Calendar.getInstance();
        DateFormat format = DateUtil.getLongYearDateFormat(locale);
        format.setLenient(false);
        cal.setTime(format.parse(dateString.trim()));
        if (cal.get(1) < 100) {
            cal.add(1, currentCenturyStartYear);
        }
        return cal.getTime();
    }

    public static String getPatternDisplayString(DateFormat dateFormat) throws ClassCastException {
        String pattern = ((SimpleDateFormat)dateFormat).toPattern().toUpperCase();
        pattern = pattern.replaceFirst("^M+/D+/", "MM/DD/");
        return pattern;
    }

    public static ParseDateResult parseDate(String dateString) {
        Locale locale = Locale.getDefault();
        DateFormat shortDateFormat = DateUtil.getLongYearDateFormat(locale);
        try {
            Date date = DateUtil.getCurrentCenturyDate(locale, dateString, 2000);
            return new ParseDateResult(date);
        }
        catch (ParseException e) {
            String formatString = "";
            try {
                formatString = DateUtil.getPatternDisplayString(shortDateFormat);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return new ParseDateResult(formatString);
        }
    }

    public static Date getNextDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, 1);
        return cal.getTime();
    }

    public static Date getPreviousDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, -1);
        return cal.getTime();
    }

    public static class ParseDateResult {
        Date date;
        boolean valid;
        String pattern;

        public ParseDateResult(Date date) {
            this.date = date;
            this.valid = true;
        }

        public ParseDateResult(String pattern) {
            this.valid = false;
            this.pattern = pattern;
        }

        public Date getDate() {
            return this.date;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

