/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class Formats {
    private static final double kilo = 1024.0;
    private static final double mega = 1048576.0;
    private static final double giga = 1.073741824E9;

    public static String getRunTime(Long runTime) {
        return runTime == null ? "" : Formats.getRunTime((long)runTime);
    }

    public static String getRunTime(long runTime) {
        DecimalFormat format = new DecimalFormat("00");
        int hours = (int)runTime / 3600;
        int minutes = (int)(runTime - (long)(hours * 3600)) / 60;
        int seconds = (int)runTime % 60;
        return String.valueOf(format.format(hours)) + ":" + format.format(minutes) + ":" + format.format(seconds);
    }

    public static long getRunTimeSeconds(String runTimeString, boolean hoursMinutesOnly) throws RuntimeException {
        StringTokenizer tokenizer = new StringTokenizer(runTimeString, ":");
        if (tokenizer.countTokens() > 3 || tokenizer.countTokens() < 1) {
            throw new RuntimeException("bad runtime format");
        }
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (hoursMinutesOnly) {
            hours = Long.parseLong(tokenizer.nextToken());
            minutes = Long.parseLong(tokenizer.nextToken());
        } else {
            if (tokenizer.countTokens() == 3) {
                hours = Long.parseLong(tokenizer.nextToken());
            }
            if (tokenizer.countTokens() == 2) {
                minutes = Long.parseLong(tokenizer.nextToken());
            }
            if (tokenizer.countTokens() == 1) {
                seconds = Long.parseLong(tokenizer.nextToken());
            }
        }
        long runTime = hours * 3600L + minutes * 60L + seconds;
        return runTime;
    }

    public static String getTruncated(String str, int maxLength) {
        if (str != null && str.length() > maxLength) {
            return String.valueOf(str.substring(0, maxLength)) + "...";
        }
        return str;
    }

    public static String getFileSize(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(bytes) + " bytes";
        }
        if ((double)bytes < 1048576.0) {
            return String.valueOf(Formats.formatFileSize((double)bytes / 1024.0)) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            return String.valueOf(Formats.formatFileSize((double)bytes / 1048576.0)) + " MB";
        }
        return String.valueOf(Formats.formatFileSize((double)bytes / 1.073741824E9)) + " GB";
    }

    private static String formatFileSize(double size) {
        int maxFractionDigits = 0;
        if (size < 10.0) {
            maxFractionDigits = 2;
        } else if (size < 100.0) {
            maxFractionDigits = 1;
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(maxFractionDigits);
        return format.format(size);
    }

    public static int getCents(String dollarsCents) throws NumberFormatException {
        if (dollarsCents.startsWith("$")) {
            dollarsCents = dollarsCents.substring(1);
        }
        return Math.round(Float.parseFloat(dollarsCents) * 100.0f);
    }

    public static String getDollarsCents(int cents) {
        NumberFormat numberFormat = Formats.getPriceFormat();
        return numberFormat.format((double)cents / 100.0);
    }

    private static NumberFormat getPriceFormat() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat;
    }

    public static boolean isValidPrice(String price) {
        try {
            Formats.getCents(price);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

