/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import com.n2bb.util.N2bbException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class N2bbEmail {
    private Log n2bbLog = LogFactory.getLog((String)"n2bbLog");
    private String user = null;
    private String host = null;
    private int pos = 0;

    public N2bbEmail(String email) throws N2bbException {
        this.n2bbLog.debug((Object)("enter email... '" + email + "'"));
        if (email == null || email.trim().equals("")) {
            throw new N2bbException("error.email.noAddress");
        }
        email = email.trim();
        StringBuffer userTemp = new StringBuffer();
        StringBuffer hostTemp = new StringBuffer();
        try {
            if (email.charAt(this.pos) == '\"') {
                userTemp.append(this.validateQuotedUser(email));
            }
            userTemp.append(this.validateUnquotedUser(email));
            this.n2bbLog.debug((Object)("user... '" + userTemp.toString() + "'"));
            if (userTemp.toString().length() == 0) {
                throw new N2bbException("error.email.noUser");
            }
            if (this.pos == email.length() || email.charAt(this.pos) != '@') {
                throw new N2bbException("error.email.noAtAfterUser");
            }
            ++this.pos;
            if (this.pos == email.length() || email.charAt(this.pos) == '.') {
                throw new N2bbException("error.email.noDomain");
            }
            if (email.indexOf(".", this.pos) == -1) {
                throw new N2bbException("error.email.noDotAfterDomain");
            }
            hostTemp.append(this.validateDomain(email));
            this.n2bbLog.debug((Object)("domain without ext... '" + hostTemp.toString() + "'"));
            if (this.pos == email.length() - 1) {
                throw new N2bbException("error.email.noExt");
            }
            hostTemp.append('.');
            ++this.pos;
            hostTemp.append(this.validateExtension(email));
            this.n2bbLog.debug((Object)("domain with ext... '" + hostTemp.toString() + "'"));
        }
        catch (N2bbException e) {
            this.n2bbLog.debug((Object)("n2bb exception - message... " + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)("exception - message... " + e.getMessage()), (Throwable)e);
            throw new N2bbException("error.email.validationFailed");
        }
        this.user = userTemp.toString();
        this.host = hostTemp.toString();
    }

    private String validateQuotedUser(String email) throws N2bbException {
        StringBuffer userTemp = new StringBuffer();
        try {
            if (email.indexOf(34, 2) == -1) {
                this.n2bbLog.debug((Object)"email has no closing quote or no text between quotes");
                throw new N2bbException("error.email.noQuote");
            }
            userTemp.append('\"');
            ++this.pos;
            while (true) {
                if (email.charAt(this.pos) == '\"') {
                    userTemp.append('\"');
                    ++this.pos;
                    break;
                }
                char c = email.charAt(this.pos);
                if (c <= '\u0000' || c == '\n' || c == '\r' || c == '\"' || c == '\\') {
                    throw new N2bbException("error.email.invalidQuote");
                }
                userTemp.append(c);
                ++this.pos;
            }
        }
        catch (N2bbException e) {
            this.n2bbLog.debug((Object)("n2bb exception - message... " + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.email.validationFailed");
        }
        return userTemp.toString();
    }

    private String validateUnquotedUser(String email) throws N2bbException {
        char[] specialChars = new char[]{'<', '>', '(', ')', '[', ']', '\\', ',', ';', ':', '@', '\"'};
        StringBuffer userTemp = new StringBuffer();
        try {
            if (email.indexOf("@") == -1) {
                this.n2bbLog.debug((Object)"email has no @ sign");
                throw new N2bbException("error.email.noAtAfterUser");
            }
            while (email.charAt(this.pos) != '@') {
                char c = email.charAt(this.pos);
                if (c <= '\u001f' || c == '\u007f' || c == ' ') {
                    throw new N2bbException("error.email.invalidUnQuote");
                }
                int i = 0;
                while (i < specialChars.length) {
                    if (c == specialChars[i]) {
                        throw new N2bbException("error.email.invalidUnQuote");
                    }
                    ++i;
                }
                userTemp.append(c);
                ++this.pos;
            }
            if (email.charAt(email.length() - 1) == '.') {
                throw new N2bbException("error.email.userNameDot");
            }
        }
        catch (N2bbException e) {
            this.n2bbLog.debug((Object)("n2bb exception - message... " + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.email.validationFailed");
        }
        return userTemp.toString();
    }

    private String validateDomain(String email) throws N2bbException {
        StringBuffer domainTemp = new StringBuffer();
        String domain = "";
        try {
            block8: {
                while (true) {
                    char c;
                    if ((c = email.charAt(this.pos)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') {
                        domainTemp.append(c);
                        ++this.pos;
                        continue;
                    }
                    if (c != '.') break;
                    if (email.charAt(this.pos - 1) == '.') {
                        throw new N2bbException("error.email.consecutiveDots");
                    }
                    if (email.indexOf(".", this.pos + 1) != -1) {
                        domainTemp.append(c);
                        ++this.pos;
                        continue;
                    }
                    break block8;
                    break;
                }
                throw new N2bbException("error.email.invalidDomain");
            }
            domain = domainTemp.toString();
            if (domain.startsWith("-") || domain.endsWith("-")) {
                throw new N2bbException("error.email.domainHyphen");
            }
        }
        catch (N2bbException e) {
            this.n2bbLog.debug((Object)("n2bb exception - message... " + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.email.validationFailed");
        }
        return domain;
    }

    private String validateExtension(String email) throws N2bbException {
        StringBuffer extTemp = new StringBuffer();
        String ext = "";
        try {
            while (this.pos != email.length()) {
                char c = email.charAt(this.pos);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    extTemp.append(c);
                    ++this.pos;
                    continue;
                }
                throw new N2bbException("error.email.invalidExt");
            }
            ext = extTemp.toString();
        }
        catch (N2bbException e) {
            this.n2bbLog.debug((Object)("n2bb exception - message... " + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            this.n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw new N2bbException("error.email.validationFailed");
        }
        return ext;
    }
}

