/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.web.util;

import com.n2bb.util.N2bbException;
import com.n2bb.util.N2bbSettings;
import com.n2bb.util.SortCriteria;
import com.n2bb.web.util.ListFilter;
import com.n2bb.web.util.ListPage;
import com.n2bb.web.util.Sort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ListPager {
    protected static final Log log = LogFactory.getLog((String)"n2bbLog");
    private int pageSize = N2bbSettings.PAGE_SIZE;
    private boolean sortAscending = true;
    private String sortColumn;
    private List list = new LinkedList();
    private boolean caching;
    private boolean cacheValid;
    private boolean sorted;
    private ListFilter filter;
    private boolean showWholeList = false;

    public int getListSize() {
        try {
            return this.getList().size();
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public int getTotalPages() {
        if (this.showWholeList) {
            return this.getListSize() > 0 ? 1 : 0;
        }
        int remainder = this.getListSize() % this.getPageSize();
        return this.getListSize() / this.getPageSize() + (remainder > 0 ? 1 : 0);
    }

    protected abstract void applySort();

    public ListPage getPage(int pageNumber) throws N2bbException {
        if (!this.isCaching() || !this.cacheValid) {
            log.debug((Object)"executing search");
            this.loadList();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.applySort();
            this.sorted = true;
        }
        int totalPages = this.getTotalPages();
        log.debug((Object)("total pages = " + totalPages));
        if (this.showWholeList) {
            return new ListPage(this.getList(), 1, 1, true);
        }
        if (totalPages == 0) {
            return new ListPage();
        }
        List c = this.getList();
        log.debug((Object)("collection size = " + c.size()));
        pageNumber = Math.max(pageNumber, 1);
        pageNumber = Math.min(pageNumber, totalPages);
        int startIndex = (pageNumber - 1) * this.getPageSize();
        int endIndex = Math.min(c.size(), startIndex + this.getPageSize());
        log.debug((Object)("startIndex = " + startIndex + ", endIndex = " + endIndex));
        List pageData = c.subList(startIndex, endIndex);
        return new ListPage(pageData, pageNumber, totalPages);
    }

    public ListPage getPage(ListFilter filter) throws N2bbException {
        this.filter = filter;
        this.cacheValid = false;
        return this.getPage(1);
    }

    public ListPage getPage(Sort sort) throws N2bbException {
        this.setSort(sort);
        return this.getPage(1);
    }

    public List getAll(Sort sort) {
        this.setSort(sort);
        log.debug((Object)("list size=" + this.getListSize()));
        return this.getList();
    }

    protected void loadList() throws N2bbException {
        this.cacheValid = true;
        this.executeSearch();
    }

    protected abstract void executeSearch() throws N2bbException;

    protected void setSort(Sort sort) {
        if (this.isSortNew(sort)) {
            this.setSortAscending(sort.isAscending());
            this.setSortColumn(sort.getColumn());
            this.sorted = false;
        }
    }

    private boolean isSortNew(Sort sort) {
        if (sort == null) {
            return false;
        }
        return !sort.getColumn().equals(this.getSortColumn()) || sort.isAscending() != this.getSortAscending();
    }

    public void setList(Collection c) {
        if (c != null) {
            this.list = new ArrayList(c);
        }
    }

    public List getList() {
        return this.list;
    }

    public void setPageSize(int size) {
        this.pageSize = size;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    private void setSortAscending(boolean isAscending) {
        this.sortAscending = isAscending;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    protected void setSortColumn(String column) {
        this.sortColumn = column;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public void invalidateCache() {
        this.cacheValid = false;
    }

    public ListFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ListFilter filter) {
        this.filter = filter;
        this.invalidateCache();
    }

    public boolean isShowWholeList() {
        return this.showWholeList;
    }

    public void setShowWholeList(boolean showWholeList) {
        this.showWholeList = showWholeList;
    }

    protected SortCriteria getSortCriteria() {
        String methodName = "get" + Character.toUpperCase(this.getSortColumn().charAt(0)) + this.getSortColumn().substring(1);
        SortCriteria sorting = new SortCriteria();
        sorting.setPrimaryMethodCriteria(methodName);
        sorting.setPrimaryOrderCriteria(this.getSortAscending() ? 1 : 2);
        return sorting;
    }
}

