/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.web.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportUtil {
    protected static Log n2bbLog = LogFactory.getLog(ReportUtil.class);
    protected PrintWriter out;
    protected HttpServletResponse response;
    protected String outputType;
    protected String headerName;
    protected String[][] filteredBy;
    protected String sortedBy;
    protected String[] columnDisplayNames;
    protected String[] columnNames;
    protected Collection records;
    protected String[] parameters;
    protected Class recordClass;

    public static void generateReport(HttpServletResponse response, String outputType, String headerName, String[][] filteredBy, String sortedBy, String[] columnDisplayNames, String[] columnNames, Collection records) {
        ReportUtil reportUtil = new ReportUtil(response, outputType, headerName, filteredBy, sortedBy, columnDisplayNames, columnNames, records);
        reportUtil.generate();
    }

    protected String formatColumnValue(String columnName, Object columnValue) {
        return "" + columnValue;
    }

    protected Object getColumnValue(Object record, String columnName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.recordClass = record.getClass();
        String methodName = "get" + columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
        Method method = this.recordClass.getMethod(methodName, null);
        return method.invoke(record, null);
    }

    public ReportUtil(HttpServletResponse response, String outputType, String headerName, String[][] filteredBy, String sortedBy, String[] columnDisplayNames, String[] columnNames, Collection records) {
        try {
            this.out = response.getWriter();
        }
        catch (IOException e) {
            n2bbLog.error((Object)"", (Throwable)e);
        }
        this.response = response;
        this.outputType = outputType;
        this.headerName = headerName;
        this.filteredBy = filteredBy;
        this.sortedBy = sortedBy;
        this.columnDisplayNames = columnDisplayNames;
        this.columnNames = columnNames;
        this.records = records;
    }

    protected ReportUtil() {
    }

    public void generate() {
        try {
            this.generateHeaderInfo();
            this.printRecords();
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void generateHeaderInfo() {
        this.printHttpHeader();
        this.printReportHeader();
        this.out.println();
        this.printFilterInfo();
        this.out.println();
        this.printSortInfo();
        this.out.println();
        this.printColumnNames();
        this.out.println();
        this.out.println();
    }

    protected void printRecords() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.records == null || this.records.size() < 1) {
            return;
        }
        for (Object record : this.records) {
            int j = 0;
            while (j < this.columnNames.length) {
                if (j > 0) {
                    this.out.print("\t");
                }
                String columnName = this.columnNames[j];
                Object columnValue = this.getColumnValue(record, columnName);
                this.out.print(this.formatColumnValue(columnName, columnValue));
                ++j;
            }
            this.out.println();
        }
    }

    protected void printHttpHeader() {
        DateFormat dateFormat = DateFormat.getDateInstance();
        DateFormat timeFormat = DateFormat.getTimeInstance(2);
        String fileName = "";
        if (this.outputType != null && this.outputType.equals("Excel")) {
            fileName = "Report " + dateFormat.format(new Date()).trim().replaceAll(",", "-") + " " + timeFormat.format(new Date()).trim().replaceAll(":", "-") + ".xls";
            this.response.setContentType("application/microsoft.ms-excel");
            this.response.setHeader("Pragma", "public");
            this.response.setHeader("Cache-Control", "max-age=0");
            this.response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        } else {
            this.response.setContentType("text/plain");
            fileName = "Report " + dateFormat.format(new Date()).trim().replaceAll(" ", "").replaceAll(",", "-") + " " + timeFormat.format(new Date()).trim().replaceAll(":", "-") + ".txt";
            this.response.setHeader("Pragma", "public");
            this.response.setHeader("Cache-Control", "max-age=0");
            this.response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        }
    }

    protected void printReportHeader() {
        this.out.println("\t\t\t\t" + this.headerName);
    }

    protected void printFilterInfo() {
        if (this.filteredBy == null) {
            return;
        }
        String filterName = "";
        String filterValue = "";
        this.out.println("Filtered By:");
        int filters = 0;
        while (filters < this.filteredBy.length && this.filteredBy.length > 0) {
            filterName = this.filteredBy[filters][0];
            filterValue = this.filteredBy[filters][1];
            if (filterValue != null && !filterValue.equals("")) {
                this.out.println("\t" + filterName + ": " + filterValue);
            }
            ++filters;
        }
    }

    protected void printSortInfo() {
        if (this.sortedBy == null) {
            return;
        }
        String sortedCriteria = "";
        this.out.println("Sorted By:");
        sortedCriteria = String.valueOf(this.sortedBy.substring(0, 1).toUpperCase()) + this.sortedBy.substring(1);
        this.out.println("\t" + sortedCriteria);
    }

    protected void printColumnNames() {
        if (this.columnDisplayNames == null) {
            return;
        }
        int columns = 0;
        while (columns < this.columnDisplayNames.length) {
            if (columns == 0) {
                this.out.print(this.columnDisplayNames[columns]);
            } else {
                this.out.print("\t" + this.columnDisplayNames[columns]);
            }
            ++columns;
        }
    }
}

