/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.web.util;

import com.n2bb.web.util.ReportUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletResponse;

public class ReportWriter
extends ReportUtil {
    public ReportWriter(HttpServletResponse response, String outputType, String headerName, String[][] filteredBy, String sortedBy, String[] columnDisplayNames, String[] columnNames, String[] parameters, Collection records) {
        try {
            this.out = response.getWriter();
        }
        catch (IOException e) {
            n2bbLog.error((Object)"", (Throwable)e);
        }
        this.response = response;
        this.outputType = outputType;
        this.headerName = headerName;
        this.filteredBy = filteredBy;
        this.sortedBy = sortedBy;
        this.columnDisplayNames = columnDisplayNames;
        this.columnNames = columnNames;
        this.records = records;
        this.parameters = parameters;
    }

    public static void generateReport(HttpServletResponse response, String outputType, String headerName, String[][] filteredBy, String sortedBy, String[] columnDisplayNames, String[] columnNames, String[] parameters, Collection records) {
        ReportWriter reportWriter = new ReportWriter(response, outputType, headerName, filteredBy, sortedBy, columnDisplayNames, columnNames, parameters, records);
        reportWriter.generate();
    }

    protected Object getColumnValue(Object record, String columnName, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] types = null;
        this.recordClass = record.getClass();
        String methodName = "get" + columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
        if (arguments != null) {
            types = new Class[]{String.class};
        }
        Method method = this.recordClass.getMethod(methodName, types);
        return method.invoke(record, arguments);
    }

    @Override
    public void printRecords() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.records == null || this.records.size() < 1) {
            return;
        }
        for (Object record : this.records) {
            int j = 0;
            while (j < this.columnNames.length) {
                if (j > 0) {
                    this.out.print("\t");
                }
                String columnName = this.columnNames[j];
                Object[] arguments = this.populateArguments(this.parameters[j]);
                Object columnValue = this.getColumnValue(record, columnName, arguments);
                this.out.print(this.formatColumnValue(columnName, columnValue));
                ++j;
            }
            this.out.println();
        }
    }

    public Object[] populateArguments(String concatenatedParameters) {
        Object[] arguments = null;
        int index = 0;
        if (!concatenatedParameters.equals("")) {
            StringTokenizer strToken = new StringTokenizer(concatenatedParameters, ",");
            arguments = new String[strToken.countTokens()];
            while (strToken.hasMoreElements()) {
                arguments[index] = strToken.nextElement().toString();
                ++index;
            }
        }
        return arguments;
    }
}

