/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.web.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebUtil {
    private static final Log log = LogFactory.getLog((String)"n2bbLog");

    public static Integer getID(HttpServletRequest request) {
        return WebUtil.getInteger(request, "id");
    }

    public static Integer getInteger(HttpServletRequest request, String parameter) {
        Integer intValue = null;
        String value = request.getParameter(parameter);
        try {
            if (value != null) {
                intValue = new Integer(value);
            }
        }
        catch (NumberFormatException ex) {
            log.error((Object)("unparseable " + parameter + ": " + value));
        }
        return intValue;
    }

    public static Long getLong(HttpServletRequest request, String parameter) {
        Long longValue = null;
        String value = request.getParameter(parameter);
        try {
            if (value != null) {
                longValue = new Long(value);
            }
        }
        catch (NumberFormatException ex) {
            log.error((Object)("unparseable " + parameter + ": " + value));
        }
        return longValue;
    }

    public static int[] getIntegerArray(String[] strings) {
        int[] ints = new int[strings.length];
        int i = 0;
        while (i < strings.length) {
            ints[i] = new Integer(strings[i]);
            ++i;
        }
        return ints;
    }

    public static long[] getLongArray(String[] strings) {
        long[] longs = new long[strings.length];
        int i = 0;
        while (i < strings.length) {
            longs[i] = new Long(strings[i]);
            ++i;
        }
        return longs;
    }

    public static short[] getSignedShortArray(String[] strings) throws NumberFormatException {
        ArrayList<Short> shortList = new ArrayList<Short>();
        int i = 0;
        while (i < strings.length) {
            String s = strings[i];
            if (s != null && !s.trim().equals("")) {
                shortList.add(WebUtil.getSignedShort(s.trim()));
            }
            ++i;
        }
        short[] shorts = new short[shortList.size()];
        int i2 = 0;
        Iterator iterator = shortList.iterator();
        while (iterator.hasNext()) {
            shorts[i2++] = (Short)iterator.next();
        }
        return shorts;
    }

    public static String[] getStringArray(short[] shorts) {
        if (shorts == null) {
            return new String[0];
        }
        String[] strings = new String[shorts.length];
        int i = 0;
        while (i < shorts.length) {
            strings[i] = "" + shorts[i];
            ++i;
        }
        return strings;
    }

    public static String[] getStringArray(Object[] objects) {
        if (objects == null) {
            return new String[0];
        }
        String[] strings = new String[objects.length];
        int i = 0;
        while (i < objects.length) {
            strings[i] = "" + objects[i];
            ++i;
        }
        return strings;
    }

    public static String[] getUnsignedShortStringArray(Short[] shorts) {
        if (shorts == null) {
            return new String[0];
        }
        String[] strings = new String[shorts.length];
        int i = 0;
        while (i < shorts.length) {
            strings[i] = "" + WebUtil.getUnsignedShort(shorts[i]);
            ++i;
        }
        return strings;
    }

    public static String[] getStringArray(Collection collection) {
        return WebUtil.getStringArray(collection.toArray(new Object[0]));
    }

    public static short[] getShortArray(Short[] shortObjects) {
        short[] shorts = new short[shortObjects.length];
        int i = 0;
        while (i < shortObjects.length) {
            Short shortObject = shortObjects[i];
            shorts[i] = shortObject == null ? (short)0 : shortObject;
            ++i;
        }
        return shorts;
    }

    public static String getExceptionID() {
        String exceptionId;
        try {
            exceptionId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ue) {
            exceptionId = "localhost";
        }
        return String.valueOf(exceptionId) + "/" + System.currentTimeMillis();
    }

    public static int getUnsignedShort(short s) {
        if (s >= 0) {
            return s;
        }
        return 65536 + s;
    }

    public static Short getSignedShort(String s) throws NumberFormatException {
        int i = Integer.parseInt(s);
        if (i < 0 || i > 65535) {
            throw new NumberFormatException(s);
        }
        if (i < Short.MAX_VALUE) {
            return new Short((short)i);
        }
        return new Short((short)(i - 65536));
    }
}

