/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ejb;

import com.tandbergtv.cms.ejb.AuthConfReaderProperties;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.workflow.auth.AuthorizationConfReader;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.InvalidPropertiesFormatException;
import java.util.Set;

public class WorkflowModuleProvider
implements IModuleProvider {
    private static final String AUTH_FILE_PATH_KEY = "authFilePath";

    public Collection<IModule> getModules() {
        String authFilePath;
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            authFilePath = AuthConfReaderProperties.getInstance().getProperty(AUTH_FILE_PATH_KEY);
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException("Unable to get authorization configuration", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get authorization configuration", e);
        }
        File authFile = new File(authFilePath);
        Set<Module> workflowModules = AuthorizationConfReader.getInstance().read(authFile);
        for (Module module : workflowModules) {
            String moduleName = module.getName();
            BasicModule userModule = new BasicModule(moduleName, moduleName);
            Collection<Permission> authPermissions = module.getPermissions();
            for (Permission authPerm : authPermissions) {
                userModule.getPermissions().add(new BasicPermission(authPerm.getName(), authPerm.getName(), moduleName));
            }
            modules.add((IModule)userModule);
        }
        return modules;
    }
}

