/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.boot;

import com.tandbergtv.watchpoint.boot.LogBootErrorHandler;
import com.tandbergtv.watchpoint.boot.ProductInfo;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.Boot;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.util.ExtendedProperties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Platform {
    private PluginManager pluginmanager;
    private static final Platform platform = new Platform();
    private static final String JPF_BOOT_FILE = "/jpf.properties";
    private static final Logger logger = Logger.getLogger(Platform.class);

    private Platform() {
    }

    public static Platform getPlatform() {
        return platform;
    }

    public PluginManager getPluginManager() {
        return this.pluginmanager;
    }

    public void start() {
        Document document = this.readDefaultConfiguration();
        List<Activator> activators = this.getActivators(document);
        this.start(activators);
    }

    public void start(String configuration) {
        Document document = this.readConfiguration(new File(configuration));
        List<Activator> activators = this.getActivators(document);
        this.start(activators);
    }

    public void stop() {
        Document document = this.readDefaultConfiguration();
        List<Activator> activators = this.getActivators(document);
        Collections.reverse(activators);
        this.stop(activators);
    }

    public void stop(String configuration) {
        Document document = this.readConfiguration(new File(configuration));
        List<Activator> activators = this.getActivators(document);
        Collections.reverse(activators);
        this.stop(activators);
    }

    private void start(Collection<Activator> activators) {
        String product = ProductInfo.getInstance().getVersionedProductName();
        logger.info((Object)(String.valueOf(product) + " starting..."));
        this.startBaseSystem();
        for (Activator activator : activators) {
            logger.debug((Object)("Class name " + activator.className));
            try {
                this.start(activator);
            }
            catch (Exception e) {
                logger.warn((Object)("Activator for " + activator.bundle + " had problems, aborting..."), (Throwable)e);
                throw new RuntimeException("Activator for " + activator.bundle + " had problems, aborting...", e);
            }
        }
        logger.info((Object)(String.valueOf(product) + " started"));
    }

    private void stop(Collection<Activator> activators) {
        for (Activator activator : activators) {
            logger.debug((Object)("Class name " + activator.className));
            try {
                this.stop(activator);
            }
            catch (Exception e) {
                logger.warn((Object)("Activator for " + activator.bundle + " had problems"), (Throwable)e);
            }
        }
        this.pluginmanager.shutdown();
        String product = ProductInfo.getInstance().getVersionedProductName();
        logger.info((Object)(String.valueOf(product) + " stopped"));
    }

    private void startBaseSystem() {
        logger.debug((Object)"Initializing the Java Plugin Framework...");
        ExtendedProperties properties = this.initializePluginProperties();
        String mode = "shell";
        properties.setProperty("jpf.boot.mode", mode);
        LogBootErrorHandler errorHandler = new LogBootErrorHandler();
        try {
            if (properties.getProperty("applicationRoot") == null) {
                String applicationRoot = new File(".").getCanonicalPath();
                properties.put((Object)"applicationRoot", (Object)applicationRoot);
            }
        }
        catch (IOException ioe) {
            String msg = "Failed to get the Application Root required by the Plugin Framework.";
            logger.warn((Object)msg, (Throwable)ioe);
        }
        try {
            Application pluginApp = Boot.boot((ExtendedProperties)properties, (boolean)false, (String)mode, (BootErrorHandler)errorHandler, (String[])new String[0]);
            this.pluginmanager = PluginManager.lookup((Object)pluginApp);
        }
        catch (Exception ex) {
            errorHandler.handleFatalError("Failed to initialize the Java Plugin Framework.", ex);
            throw new RuntimeException("Failed to initialize the Plugin Manager.", ex);
        }
        logger.info((Object)"Successfully initialized the Java Plugin Framework.");
    }

    private ExtendedProperties initializePluginProperties() {
        ExtendedProperties properties = new ExtendedProperties(System.getProperties());
        try {
            InputStream strm = this.getClass().getResourceAsStream(JPF_BOOT_FILE);
            try {
                properties.load(strm);
            }
            finally {
                strm.close();
            }
        }
        catch (IOException ioe) {
            String msg = "Failed to load the JPF boot configuration file: /jpf.properties.";
            throw new RuntimeException(msg, ioe);
        }
        return properties;
    }

    private void start(Activator activator) throws Exception {
        Object instance = this.getClass().getClassLoader().loadClass(activator.className).newInstance();
        Method method = instance.getClass().getMethod("start", new Class[0]);
        method.invoke(instance, new Object[0]);
    }

    private void stop(Activator activator) throws Exception {
        Object instance = this.getClass().getClassLoader().loadClass(activator.className).newInstance();
        Method method = instance.getClass().getMethod("stop", new Class[0]);
        method.invoke(instance, new Object[0]);
    }

    private List<Activator> getActivators(Document document) {
        ArrayList<Activator> activators = new ArrayList<Activator>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("//activator", document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                String className = node.getAttributes().getNamedItem("class").getTextContent();
                String bundle = node.getAttributes().getNamedItem("bundle").getTextContent();
                Activator activator = new Activator(bundle, className);
                activators.add(activator);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read activator configuration", e);
        }
        return activators;
    }

    private Document readConfiguration(File file) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read activator configuration: " + file.getAbsolutePath(), e);
        }
        return document;
    }

    private Document readDefaultConfiguration() {
        Document document = null;
        try {
            document = XMLDocumentUtility.loadFile("com/tandbergtv/watchpoint/boot/activator.xml");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read default activator configuration", e);
        }
        return document;
    }

    private class Activator {
        String bundle;
        String className;

        public Activator(String bundle, String className) {
            this.bundle = bundle;
            this.className = className;
        }
    }
}

