/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.webservice;

import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.webservice.AdaptorRequestFactoryException;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.internal.DeviceFactory;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageAttachment;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class AdaptorRequestFactory {
    private static final Logger logger = Logger.getLogger(AdaptorRequestFactory.class);

    private AdaptorRequestFactory() {
    }

    public static AdaptorRequestFactory newInstance() {
        return new AdaptorRequestFactory();
    }

    public IAdaptorRequest createRequest(SOAPMessage message) {
        return new AdaptorRequestImpl(this.convertSOAPMessage(message));
    }

    public IAdaptorRequest createRequest(SOAPMessage message, String host, int port) {
        ISource device;
        String url = "tcp://" + host + ":" + port;
        try {
            device = (ISource)DeviceFactory.newInstance().createDevice(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        logger.debug((Object)("Source is " + url));
        return new AdaptorRequestImpl(this.convertSOAPMessage(message), device);
    }

    private IMessage convertSOAPMessage(SOAPMessage message) {
        MessageImpl msg = null;
        try {
            SOAPBody body = message.getSOAPBody();
            Iterator iterator = body.getChildElements();
            if (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                logger.debug((Object)("Element name is: " + element.getNodeName()));
                IPayload payload = this.getPayload(element);
                logger.debug((Object)("Payload is: " + payload));
                HTTPAttachment attachment = this.getAttachment(message);
                msg = new MessageImpl(payload, (IMessageAttachment)attachment);
            }
        }
        catch (Exception e) {
            throw new AdaptorRequestFactoryException("Failed to create message", e);
        }
        return msg;
    }

    private HTTPAttachment getAttachment(SOAPMessage message) throws SOAPException {
        int count = message.countAttachments();
        logger.debug((Object)("Message contains " + count + " attachment(s)"));
        Iterator i = message.getAttachments();
        if (i.hasNext()) {
            AttachmentPart part = (AttachmentPart)i.next();
            logger.info((Object)("Attachment content-type is " + part.getContentType()));
            return new HTTPAttachment(part.getContent(), part.getContentType());
        }
        return null;
    }

    private IPayload getPayload(Element root) throws TransformerException {
        StringWriter w = new StringWriter();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(root), new StreamResult(w));
        return new StringPayload(w.toString());
    }
}

