/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth;

import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import com.tandbergtv.workflow.auth.jaxb.ActionType;
import com.tandbergtv.workflow.auth.jaxb.Authorization;
import com.tandbergtv.workflow.auth.jaxb.MenuType;
import com.tandbergtv.workflow.auth.jaxb.SectionType;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class AuthorizationConfReader {
    private static AuthorizationConfReader _instance;

    private AuthorizationConfReader() {
    }

    public static synchronized AuthorizationConfReader getInstance() {
        if (_instance == null) {
            _instance = new AuthorizationConfReader();
        }
        return _instance;
    }

    public Set<Module> read(File authFile) {
        HashSet<Module> modules = new HashSet<Module>();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)(String.valueOf(AuthorizationConfReader.class.getPackage().getName()) + ".jaxb"));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Authorization auth = (Authorization)unmarshaller.unmarshal(authFile);
            List<Authorization.Module> jaxbModulesList = auth.getModule();
            if (jaxbModulesList != null) {
                for (Authorization.Module jaxbModule : auth.getModule()) {
                    modules.add(this.convert(jaxbModule));
                }
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to get authorization configuration", e);
        }
        return modules;
    }

    private Module convert(Authorization.Module jaxbModule) {
        Module m = new Module();
        m.setName(jaxbModule.getName());
        List<Authorization.Module.Permission> jaxbPermissions = jaxbModule.getPermission();
        if (jaxbPermissions != null) {
            for (Authorization.Module.Permission jaxbPermission : jaxbPermissions) {
                m.addPermission(this.convert(jaxbPermission));
            }
        }
        return m;
    }

    private Permission convert(Authorization.Module.Permission jaxbPermission) {
        List<SectionType> jaxbSectionsList;
        List<ActionType> jaxbActionsList;
        Permission p = new Permission();
        p.setName(jaxbPermission.getName());
        List<MenuType> jaxbMenuList = jaxbPermission.getMenu();
        if (jaxbMenuList != null) {
            for (MenuType jaxbMenu : jaxbMenuList) {
                p.addMenu(jaxbMenu.getName());
            }
        }
        if ((jaxbActionsList = jaxbPermission.getAction()) != null) {
            for (ActionType jaxbAction : jaxbActionsList) {
                p.addAction(jaxbAction.getUrl());
            }
        }
        if ((jaxbSectionsList = jaxbPermission.getSection()) != null) {
            for (SectionType jaxbSection : jaxbSectionsList) {
                p.addSection(jaxbSection.getName());
            }
        }
        return p;
    }
}

