/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth;

import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.entity.IPermission;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.workflow.auth.AuthorizationConfReader;
import com.tandbergtv.workflow.auth.AuthorizationException;
import com.tandbergtv.workflow.auth.Credentials;
import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public final class AuthorizationManager
implements IAuthorizationManager {
    private static final Logger logger = Logger.getLogger(AuthorizationManager.class);
    private static final String AUTH_FILE_NAME = "auth.xml";
    private SessionFactory factory;
    private Map<String, Module> modules = new HashMap<String, Module>();

    public AuthorizationManager(SessionFactory factory) {
        this.factory = factory;
    }

    public void start() {
        String confDir;
        try {
            confDir = ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath");
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException("Unable to get configuration directory.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get configuration directory.", e);
        }
        File authFile = new File(confDir, AUTH_FILE_NAME);
        for (Module module : AuthorizationConfReader.getInstance().read(authFile)) {
            this.modules.put(module.getName(), module);
        }
        logger.info((Object)("Authorization manager initialized, cached " + this.modules.size() + " modules"));
    }

    public void stop() {
        logger.debug((Object)"Authorization manager destroyed");
    }

    public String getServiceName() {
        return "Authorization Manager";
    }

    @Override
    public Credentials getCredentials(Principal principal) throws AuthorizationException {
        HashSet<String> actions = new HashSet<String>();
        HashSet<String> sections = new HashSet<String>();
        HashSet<String> menus = new HashSet<String>();
        try {
            InitialContext context = new InitialContext();
            IAuthorizationService neptuneAuthService = (IAuthorizationService)context.lookup("/cms/AuthorizationService/local");
            Set userModules = neptuneAuthService.getAuthorizedPermissionsByModule();
            logger.debug((Object)("userModules.size()=" + userModules.size()));
            for (IModule userModule : userModules) {
                logger.debug((Object)("userModule = " + userModule.getName()));
                Module module = this.modules.get(userModule.getName());
                if (module == null) continue;
                for (IPermission userPermission : userModule.getPermissions()) {
                    logger.debug((Object)("userPermission = " + userPermission.getName()));
                    Permission permission = module.getPermission(userPermission.getName());
                    if (permission == null) continue;
                    actions.addAll(permission.getActions());
                    sections.addAll(permission.getSections());
                    menus.addAll(permission.getMenus());
                }
            }
            logger.debug((Object)("actions = " + actions));
            logger.debug((Object)("sections = " + sections));
            logger.debug((Object)("menus = " + sections));
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to get credentials", e);
        }
        return new Credentials(principal, actions, sections, menus);
    }

    @Override
    public List<ProtectionKey> getAllProtectionKeys() {
        Session session = this.getSession();
        ArrayList<ProtectionKey> protectionKeys = new ArrayList<ProtectionKey>();
        try {
            List list = session.createCriteria(ProtectionKey.class).addOrder(Order.asc((String)"name")).list();
            for (Object obj : list) {
                protectionKeys.add((ProtectionKey)obj);
            }
        }
        finally {
            this.closeSession(session);
        }
        return protectionKeys;
    }

    @Override
    public ProtectionKey getProtectionKey(int protKeyID) {
        List<ProtectionKey> protKeys = this.getAllProtectionKeys();
        for (ProtectionKey protKey : protKeys) {
            if (protKeyID != protKey.getId()) continue;
            return protKey;
        }
        return null;
    }

    @Override
    public ProtectionKey getProtectionKey(String name) {
        for (ProtectionKey key : this.getAllProtectionKeys()) {
            if (!name.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        this.save(key);
    }

    @Override
    public int getProtectionKeyIDForName(String protKeyName, boolean createIfNotExists) {
        for (ProtectionKey protectionKey : this.getAllProtectionKeys()) {
            if (protectionKey == null || protectionKey.getName() == null || !protectionKey.getName().equals(protKeyName)) continue;
            return protectionKey.getId();
        }
        if (createIfNotExists) {
            ProtectionKey protectionKey;
            logger.info((Object)("Creating a new protection key in database | Protection Key Name: " + protKeyName));
            protectionKey = new ProtectionKey();
            protectionKey.setName(protKeyName);
            this.save(protectionKey);
            return this.getProtectionKeyIDForName(protKeyName, false);
        }
        return -1;
    }

    private Object save(Object entity) {
        Session session = this.getSession();
        Transaction t = session.beginTransaction();
        try {
            try {
                session.save(entity);
                t.commit();
            }
            catch (RuntimeException e) {
                if (t != null) {
                    t.rollback();
                }
                throw e;
            }
        }
        finally {
            this.closeSession(session);
        }
        return entity;
    }

    private Session getSession() {
        return this.factory.openSession();
    }

    private void closeSession(Session session) {
        session.close();
    }
}

