/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.dao.hibernate;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.function.ClassicAvgFunction;
import org.hibernate.dialect.function.ClassicCountFunction;
import org.hibernate.dialect.function.ClassicSumFunction;
import org.hibernate.dialect.function.SQLFunction;

public class HibernateUtil {
    private static SessionFactory sessionFactory;
    private static final String HIBERNATE_CONFIG_RESOURCE = "/com/tandbergtv/workflow/dao/hibernate.cfg.xml";

    public static void initialize() {
        try {
            Configuration configuration = new Configuration();
            configuration.configure(HIBERNATE_CONFIG_RESOURCE);
            configuration.addSqlFunction("count", (SQLFunction)new ClassicCountFunction());
            configuration.addSqlFunction("avg", (SQLFunction)new ClassicAvgFunction());
            configuration.addSqlFunction("sum", (SQLFunction)new ClassicSumFunction());
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void close() {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
    }
}

