/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command.buffer;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.driver.command.buffer.ICommandBuffer;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.message.util.DefaultMessageKeyGenerator;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jbpm.graph.exe.Token;

public class CommandBuffer
implements ICommandBuffer {
    private Collection<SoftReference<ICommand>> commands;
    private String uid;
    private Lock lock;

    public CommandBuffer(String uid) {
        this.uid = uid;
        this.commands = new TreeSet<SoftReference<ICommand>>(new CommandComparator());
        this.lock = new ReentrantLock();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public int getSize() {
        return this.commands.size();
    }

    public void addCommand(ICommand command) {
        this.lock.lock();
        this.commands.add(new SoftReference<ICommand>(command));
        this.lock.unlock();
    }

    public ICommand removeCommand(CustomToken token, Map<String, Object> parameters) {
        IMessageKey key = new DefaultMessageKeyGenerator().generate((Token)token);
        ICommand ret = null;
        this.lock.lock();
        try {
            Iterator<SoftReference<ICommand>> i = this.commands.iterator();
            while (i.hasNext()) {
                SoftReference<ICommand> ref = i.next();
                ICommand command = ref.get();
                if (command == null) {
                    i.remove();
                    continue;
                }
                WorkflowMessage message = command.getMessage();
                if (!key.equals(message.getKey()) && !message.match(parameters)) continue;
                i.remove();
                ret = command;
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    @Override
    public void flush() {
        this.commands.clear();
    }

    class CommandComparator<T>
    implements Comparator<SoftReference<ICommand>> {
        CommandComparator() {
        }

        @Override
        public int compare(SoftReference<ICommand> o1, SoftReference<ICommand> o2) {
            ICommand c1 = o1.get();
            ICommand c2 = o2.get();
            if (c1 == null && c2 == null) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            return ((Comparable)Comparable.class.cast(c1)).compareTo(c2);
        }
    }
}

