/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command.buffer;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.command.buffer.CommandBuffer;
import com.tandbergtv.workflow.driver.command.buffer.DelayedCommand;
import com.tandbergtv.workflow.driver.command.buffer.ICommandBuffer;
import com.tandbergtv.workflow.driver.command.buffer.IDelayedCommandService;
import com.tandbergtv.workflow.driver.event.MessageListenEvent;
import com.tandbergtv.workflow.message.command.ICommand;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class DelayedCommandService
implements IDelayedCommandService {
    private ConcurrentMap<String, CommandBuffer> buffers;
    private static final String NAME = "delayed-command";
    private static final String MBEAN_NAME = "com.tandbergtv.watchpoint:type=Buffer,name=";
    private ISchedulerService<Void> scheduler = new Scheduler("delayed-command", 1, 1);
    private static final Logger logger = Logger.getLogger(DelayedCommandService.class);

    @Override
    public void addCommand(ICommand command) {
        String uid = command.getMessage().getMessageUID().getUID();
        CommandBuffer old = this.buffers.putIfAbsent(uid, new CommandBuffer(uid));
        CommandBuffer buffer = (CommandBuffer)this.buffers.get(uid);
        if (old == null) {
            this.registerMBean(buffer);
        }
        buffer.addCommand(new DelayedCommand(command));
        logger.info((Object)("[" + uid + "] added command for delayed execution"));
    }

    public String getServiceName() {
        return NAME;
    }

    public void start() {
        this.buffers = new ConcurrentHashMap<String, CommandBuffer>();
        this.scheduler.start();
        DefaultMediator.getInstance().register((IColleague)this);
    }

    public void stop() {
        for (String uid : this.buffers.keySet()) {
            CommandBuffer buffer = (CommandBuffer)this.buffers.get(uid);
            this.unregisterMBean(buffer);
            buffer.flush();
        }
        this.buffers.clear();
        this.scheduler.stop();
        DefaultMediator.getInstance().unregister((IColleague)this);
    }

    public String getColleagueName() {
        return NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof MessageListenEvent)) {
            return;
        }
        final MessageListenEvent e = (MessageListenEvent)MessageListenEvent.class.cast(event);
        String uid = e.getUid();
        logger.info((Object)(e.getToken() + ", trying to locate " + uid));
        final CommandBuffer buffer = (CommandBuffer)this.buffers.get(uid);
        if (buffer == null) {
            return;
        }
        this.scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ICommand command = buffer.removeCommand(e.getToken(), e.getParameters());
                if (command != null) {
                    command.execute();
                }
                return null;
            }
        });
    }

    private void registerMBean(CommandBuffer buffer) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String uid = buffer.getUid();
        try {
            server.registerMBean(new StandardMBean(buffer, ICommandBuffer.class), new ObjectName(MBEAN_NAME + uid));
        }
        catch (Exception e) {
            logger.warn((Object)("Command buffer MBean registration failed for uid " + uid), (Throwable)e);
        }
    }

    private void unregisterMBean(CommandBuffer buffer) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String uid = buffer.getUid();
        try {
            server.unregisterMBean(new ObjectName(MBEAN_NAME + uid));
        }
        catch (Exception e) {
            logger.warn((Object)("Command buffer MBean unregistration failed for uid " + uid), (Throwable)e);
        }
    }
}

