/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class TaskNotificationHandler
implements ActionHandler {
    private static final long serialVersionUID = 808303070540099586L;
    private static final Logger logger = Logger.getLogger(TaskNotificationHandler.class);
    private static final String MAIL_SERVICE_KEY = "mail.service.jndi.name";
    private static final String BUNDLE_NAME = String.valueOf(TaskNotificationHandler.class.getPackage().getName()) + ".mail";

    public void execute(ExecutionContext ec) throws Exception {
        Resource resource = this.getResource(ec);
        if (resource.getResourceType().getConnectionType() != ResourceConnectionType.EMAIL) {
            throw new ActionException("Resource [" + resource.getId() + "] does not have an email address");
        }
        WorkflowProcess process = (WorkflowProcess)ec.getProcessInstance();
        String id = String.valueOf(process.getId());
        String taskId = String.valueOf(this.getCurrentTaskInstanceId(ec));
        logger.info((Object)("[" + id + "] got resource [" + resource.getId() + "] " + resource.getName() + " (" + resource.getConnectionString() + ")"));
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            InitialContext context = new InitialContext();
            Session session = (Session)context.lookup(bundle.getString(MAIL_SERVICE_KEY));
            MimeMessage message = new MimeMessage(session);
            message.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(resource.getConnectionString()));
            message.setSubject(bundle.getString("mail.subject"));
            String pattern = String.valueOf(ApplicationProperties.getInstance().getProperty("application.url")) + bundle.getString("mail.task.url");
            String url = MessageFormat.format(pattern, id, taskId);
            message.setText(String.valueOf(bundle.getString("mail.body")) + System.getProperty("line.separator") + url);
            Transport.send((Message)message);
            logger.debug((Object)("Sent email to " + resource.getConnectionString()));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send email to " + resource.getConnectionString()), (Throwable)e);
        }
    }

    private Long getCurrentTaskInstanceId(ExecutionContext ec) {
        Long taskId = null;
        WorkflowProcess process = (WorkflowProcess)ec.getProcessInstance();
        TaskMgmtInstance tmi = process.getTaskMgmtInstance();
        ArrayList tasks = new ArrayList();
        for (CustomToken token : process.findAllTokens()) {
            tasks.addAll(tmi.getUnfinishedTasks((Token)token));
        }
        for (TaskInstance task : tasks) {
            if (!task.getTask().getTaskNode().equals((Object)ec.getNode()) || task.hasEnded()) continue;
            taskId = task.getId();
            break;
        }
        if (taskId == null) {
            throw new ActionException(process + " does not have a valid manual task");
        }
        return taskId;
    }

    protected Resource getResource(ExecutionContext context) {
        ContextInstance c = context.getProcessInstance().getContextInstance();
        Resource resource = (Resource)c.getTransientVariable("_resource_" + context.getToken().getId());
        if (resource == null) {
            throw new ActionException(context.getToken() + ", resource unavailable");
        }
        return resource;
    }
}

