/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.log.AbstractDAOFactory;
import com.tandbergtv.workflow.log.IWorkflowMessageLogDAO;
import com.tandbergtv.workflow.log.IWorkflowNodeLogDAO;
import com.tandbergtv.workflow.log.LogQueueDrainer;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import com.tandbergtv.workflow.log.hibernate.HibernateDAOFactory;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import com.tandbergtv.workflow.log.mgmt.EventQueue;
import com.tandbergtv.workflow.util.SortingOrder;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;

public class WorkflowLogManager
implements IColleague,
Service {
    private static final Logger logger = Logger.getLogger(WorkflowLogManager.class);
    private boolean initialized = false;
    private Collection<LogQueueDrainer> drainers = new ArrayList<LogQueueDrainer>();
    private HibernateDAOFactory daofactory;

    private WorkflowLogManager() {
    }

    public WorkflowLogManager(HibernateDAOFactory daofactory) {
        this();
        this.daofactory = daofactory;
    }

    public String getServiceName() {
        return "Logger";
    }

    public void start() {
        if (this.initialized) {
            logger.info((Object)"Workflow Log Manager already initialized. Ignoring the initialize() call.");
            return;
        }
        logger.info((Object)"Initializing the Workflow Log Manager...");
        this.configure();
        DefaultMediator.getInstance().register((IColleague)this);
        this.initialized = true;
    }

    public void stop() {
        logger.info((Object)"Destroying the Workflow Log Manager...");
        DefaultMediator.getInstance().unregister((IColleague)this);
        for (LogQueueDrainer drainer : this.drainers) {
            drainer.stop();
        }
        this.drainers.clear();
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".logger");
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            this.unregisterMBean("com.tandbergtv.watchpoint:type=Queue,name=" + e.nextElement());
        }
        this.initialized = false;
    }

    public SessionFactory getSessionFactory() {
        return this.daofactory.getSessionFactory();
    }

    public AbstractDAOFactory getDAOFactory() {
        return this.daofactory;
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        logger.debug((Object)("Adding to the drainer: " + event));
        for (LogQueueDrainer drainer : this.drainers) {
            drainer.drainEvent(event);
        }
        logger.debug((Object)"Added...");
    }

    private void configure() {
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".logger");
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            logger.debug((Object)("Key " + key));
            String[] classNames = bundle.getString(key).split(",");
            IWorkflowLogger[] loggers = new IWorkflowLogger[classNames.length];
            int i = 0;
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                try {
                    logger.debug((Object)("Class name " + className));
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(className.trim());
                    Constructor<?> constructor = clazz.getConstructor(SessionFactory.class);
                    loggers[i++] = (IWorkflowLogger)constructor.newInstance(this.getSessionFactory());
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to create logger " + className + ", events will not be saved"), t);
                }
                ++n2;
            }
            this.addLogger(key, loggers);
        }
    }

    private void addLogger(String name, IWorkflowLogger ... loggers) {
        LogQueueDrainer drainer = new LogQueueDrainer(loggers);
        this.drainers.add(drainer);
        this.registerMBean(new EventQueue(drainer), "com.tandbergtv.watchpoint:type=Queue,name=" + name);
        Thread t = new Thread((Runnable)drainer, name);
        t.setDaemon(true);
        t.start();
    }

    private void registerMBean(IQueueMonitor monitor, String name) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(monitor, IQueueMonitor.class);
            server.registerMBean(mbean, new ObjectName(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unregisterMBean(String name) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<NodeLog> getHistoryTasks(List<CustomToken> tokens, int numRecords, int startingRecordNum) {
        List jbpmNodeLogs;
        Session session = this.getSessionFactory().openSession();
        try {
            jbpmNodeLogs = session.createQuery(this.buildHistoryTasksQuery(tokens, false)).setMaxResults(numRecords).setFirstResult(startingRecordNum).list();
        }
        finally {
            session.close();
        }
        return jbpmNodeLogs;
    }

    public int getHistoryTasksCount(List<CustomToken> tokens) {
        Session session = this.getSessionFactory().openSession();
        try {
            int n = (Integer)session.createQuery(this.buildHistoryTasksQuery(tokens, true)).uniqueResult();
            return n;
        }
        finally {
            session.close();
        }
    }

    private String buildHistoryTasksQuery(List<CustomToken> tokens, boolean count) {
        StringBuffer query = count ? new StringBuffer("select count(*) ") : new StringBuffer("select n ");
        query.append("from NodeLog n where n.token in (");
        int i = 0;
        while (i < tokens.size()) {
            query.append(tokens.get(i).getId());
            if (i != tokens.size() - 1) {
                query.append(", ");
            }
            ++i;
        }
        query.append(") and n.node.superState is null order by date");
        return query.toString();
    }

    public List<WorkflowMessageLog> getHistoryTaskMessages(long historyTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        IWorkflowMessageLogDAO messageLogDAO = this.daofactory.getWorkflowMessageLogDAO();
        return messageLogDAO.findByJBPMNodeLogID(historyTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getHistoryTaskMessagesCount(long historyTaskMessagesKey) {
        IWorkflowMessageLogDAO messageLogDAO = this.daofactory.getWorkflowMessageLogDAO();
        return messageLogDAO.countByJBPMNodeLogID(historyTaskMessagesKey);
    }

    public List<WorkflowMessageLog> getCurrentTaskMessages(long currentTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        IWorkflowMessageLogDAO messageLogDAO = this.daofactory.getWorkflowMessageLogDAO();
        return messageLogDAO.findByWorkflowNodeLogID(currentTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getCurrentTaskMessagesCount(long currentTaskMessagesKey) {
        IWorkflowMessageLogDAO messageLogDAO = this.daofactory.getWorkflowMessageLogDAO();
        return messageLogDAO.countByWorkflowNodeLogID(currentTaskMessagesKey);
    }

    public long getCurrentTaskMessagesKey(Token token, Node node) {
        IWorkflowNodeLogDAO wfsNodeLogDAO = this.daofactory.getWorkflowNodeLogDAO();
        WorkflowNodeLog workflowNodeLog = wfsNodeLogDAO.findCurrentByTokenAndNode(token, node);
        return workflowNodeLog != null ? workflowNodeLog.getId() : -1L;
    }

    public int getHistoryTaskIteration(long historyTaskID) {
        Session session = this.getSessionFactory().openSession();
        try {
            String queryString = "select count(*) from NodeLog n where n.node.id = (select n1.node.id from NodeLog n1 where n1.id = " + historyTaskID + ") and n.token.processInstance = (select n2.token.processInstance from NodeLog n2 where n2.id = " + historyTaskID + ") and n.id <= " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = (Integer)query.uniqueResult();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get iteration number of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            return -1;
        }
        finally {
            session.close();
        }
    }

    public int getHistoryTaskNumIterations(long historyTaskID) {
        Session session = this.getSessionFactory().openSession();
        try {
            String queryString = "select count(wnl) from WorkflowNodeLog wnl, NodeLog nl where wnl.node = nl.node and wnl.token.processInstance = nl.token.processInstance and nl.id = " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = (Integer)query.uniqueResult();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get total # iterations of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            return -1;
        }
        finally {
            session.close();
        }
    }

    public int getCurrentTaskIteration(long currentTaskMessagesKey) {
        Session session = this.getSessionFactory().openSession();
        try {
            String queryString = "select count(*) from WorkflowNodeLog wnl where wnl.node.id = (select wnl1.node.id from WorkflowNodeLog wnl1 where wnl1.id = " + currentTaskMessagesKey + ") and wnl.token.processInstance = (select wnl2.token.processInstance from WorkflowNodeLog wnl2 where wnl2.id = " + currentTaskMessagesKey + ") and wnl.id <= " + currentTaskMessagesKey;
            Query query = session.createQuery(queryString);
            int n = (Integer)query.uniqueResult();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get iteration number of current task | currentTaskMessagesKey: " + currentTaskMessagesKey), (Throwable)e);
            return -1;
        }
        finally {
            session.close();
        }
    }
}

