/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.hibernate;

import com.tandbergtv.workflow.dao.HibernateDAO;
import com.tandbergtv.workflow.log.IWorkflowMessageLogDAO;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class WorkflowMessageLogHDAO
extends HibernateDAO<WorkflowMessageLog, Long>
implements IWorkflowMessageLogDAO {
    private static final Logger logger = Logger.getLogger(WorkflowMessageLogHDAO.class);

    public WorkflowMessageLogHDAO(Session session) {
        super(WorkflowMessageLog.class, session);
    }

    @Override
    public List<WorkflowMessageLog> findByJBPMNodeLogID(long jbpmNodeLogID, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        Session session = this.getSession();
        try {
            logger.debug((Object)("Retrieving the message logs associated with jbpmNodeLog - ID: " + jbpmNodeLogID));
            String sortOrderStr = sortOrder == SortingOrder.ASCENDING ? "asc" : "desc";
            String query = String.valueOf(this.buildFindByJBPMNodeLogIDQuery(jbpmNodeLogID, false)) + " order by " + sortColumn + " " + sortOrderStr;
            Query q = session.createQuery(query).setMaxResults(numRecords).setFirstResult(startingRecordNum);
            List list = q.list();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not get message logs associated with jbpmNodeLog - ID: " + jbpmNodeLogID), (Throwable)ex);
        }
        finally {
            session.close();
        }
        return null;
    }

    @Override
    public int countByJBPMNodeLogID(long jbpmNodeLogID) {
        Session session = this.getSession();
        try {
            logger.debug((Object)("Finding the count of message logs associated with nodelog - jbpmNodeLogID: " + jbpmNodeLogID));
            String query = this.buildFindByJBPMNodeLogIDQuery(jbpmNodeLogID, true);
            Query q = session.createQuery(query);
            int n = (Integer)q.uniqueResult();
            return n;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not get count of message logs associated with nodelog - jbpmNodeLogID: " + jbpmNodeLogID), (Throwable)ex);
        }
        finally {
            session.close();
        }
        return -1;
    }

    private String buildFindByJBPMNodeLogIDQuery(long jbpmNodeLogID, boolean count) {
        String query = count ? "select count(*) " : "select m ";
        query = String.valueOf(query) + "from WorkflowMessageLog m where m.nodeLog.id = (select max(wnl.id) from WorkflowNodeLog wnl, NodeLog jnl where wnl.token = jnl.token and wnl.node = jnl.node and wnl.id < jnl.id and jnl.id = " + jbpmNodeLogID + ")";
        return query;
    }

    @Override
    public WorkflowMessageLog store(WorkflowMessageLog entity) {
        WorkflowMessageLog newEntity = null;
        Session session = this.getSession();
        try {
            try {
                session.beginTransaction();
                newEntity = entity.getId() > 0L ? super.update(entity) : super.create(entity);
                session.getTransaction().commit();
            }
            catch (Exception ex) {
                logger.error((Object)"Could not insert the WorkflowMessageLog", (Throwable)ex);
                try {
                    session.getTransaction().rollback();
                }
                catch (Exception iex) {
                    logger.error((Object)"Could not rollback the insertion of WorkflowMessageLog", (Throwable)iex);
                }
                session.close();
            }
        }
        finally {
            session.close();
        }
        return newEntity;
    }

    @Override
    public int countByWorkflowNodeLogID(long workflowNodeLogID) {
        Session session = this.getSession();
        try {
            logger.debug((Object)("Retrieving the message logs for workflowNodeLogID: " + workflowNodeLogID));
            Criteria criteria = session.createCriteria(WorkflowMessageLog.class).add((Criterion)Expression.eq((String)"nodeLog.id", (Object)workflowNodeLogID)).setProjection(Projections.rowCount());
            int n = (Integer)criteria.uniqueResult();
            return n;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not load the messages for workflowNodeLogID: " + workflowNodeLogID), (Throwable)ex);
        }
        finally {
            session.close();
        }
        return -1;
    }

    @Override
    public List<WorkflowMessageLog> findByWorkflowNodeLogID(long workflowNodeLogID, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        Session session = this.getSession();
        try {
            logger.debug((Object)("Retrieving the message logs for workflowNodeLogID: " + workflowNodeLogID));
            Order order = sortOrder == SortingOrder.ASCENDING ? Order.asc((String)sortColumn) : Order.desc((String)sortColumn);
            Criteria criteria = session.createCriteria(WorkflowMessageLog.class).add((Criterion)Expression.eq((String)"nodeLog.id", (Object)workflowNodeLogID)).setMaxResults(numRecords).setFirstResult(startingRecordNum).addOrder(order);
            List<WorkflowMessageLog> list = this.findByCriteria(criteria);
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not load the messages for workflowNodeLogID: " + workflowNodeLogID), (Throwable)ex);
        }
        finally {
            session.close();
        }
        return null;
    }
}

