/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.jbpm.logging.log.ProcessLog;

public class ProcessStatusPerResourceLogger
implements IWorkflowLogger {
    private SessionFactory sessionFactory;
    private static final Logger logger = Logger.getLogger(ProcessStatusPerResourceLogger.class);

    public ProcessStatusPerResourceLogger(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public boolean match(Object logEvent) {
        return logEvent instanceof WorkflowProcessStatusLogEvent;
    }

    @Override
    public void execute(Object eventObj) {
        if (!(eventObj instanceof WorkflowProcessStatusLogEvent)) {
            logger.debug((Object)"Not a WorkflowProcessStatusLogEvent object. Ignored.");
            return;
        }
        ProcessLog processLog = this.convertToProcessStatusLog((WorkflowProcessStatusLogEvent)((Object)eventObj));
        CustomToken token = (CustomToken)CustomToken.class.cast(processLog.getToken());
        if (!token.isTrace()) {
            logger.debug((Object)(token + " not being traced, ignored"));
            return;
        }
        this.save(processLog);
    }

    private ProcessLog convertToProcessStatusLog(WorkflowProcessStatusLogEvent statusEvent) {
        ProcessStatusPerResourceLog pl = null;
        pl = statusEvent.isQueued() ? new ProcessQueuedPerResourceLog(statusEvent.getToken(), statusEvent.getNode(), statusEvent.getTaskInstance(), statusEvent.getResourceGroup(), statusEvent.getResource(), statusEvent.getStartTime(), statusEvent.getEndTime(), statusEvent.getOperationalStatus(), statusEvent.getAdminStatus()) : new ProcessStatusPerResourceLog(statusEvent.getToken(), statusEvent.getNode(), statusEvent.getTaskInstance(), statusEvent.getResourceGroup(), statusEvent.getResource(), statusEvent.getStartTime(), statusEvent.getEndTime(), statusEvent.getOperationalStatus(), statusEvent.getAdminStatus());
        return pl;
    }

    private void save(Object log) {
        Session session = this.sessionFactory.openSession();
        try {
            try {
                session.beginTransaction();
                session.saveOrUpdate(log);
                session.getTransaction().commit();
                logger.debug((Object)("Stored log to database. " + log));
            }
            catch (Exception ex) {
                logger.error((Object)"Could not store the log", (Throwable)ex);
                session.getTransaction().rollback();
                session.close();
            }
        }
        finally {
            session.close();
        }
    }
}

