/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.command;

import com.tandbergtv.workflow.core.queue.Queue;
import com.tandbergtv.workflow.core.queue.QueueItem;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.CompositeCommand;
import com.tandbergtv.workflow.message.command.ICommand;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class CommandFilter
extends CompositeCommand {
    private static final String QUEUE_NAME = "com.tandbergtv.workflow.mq";
    private static final String BUNDLE_NAME = String.valueOf(CommandFilter.class.getPackage().getName()) + ".filter";
    private static final Logger logger = Logger.getLogger(CommandFilter.class);

    public CommandFilter(ICommand command) {
        super(command);
    }

    @Override
    public WorkflowMessage execute() {
        if (!this.filter()) {
            return super.execute();
        }
        Queue mq = (Queue)ServiceRegistry.getDefault().lookup(QUEUE_NAME);
        if (mq == null) {
            return super.execute();
        }
        WorkflowMessage response = this.createSuccessResponse();
        response.setPayload(this.message.getPayload());
        try {
            mq.insert(new QueueItem((Object)this.message));
        }
        catch (Exception e) {
            response = this.createErrorResponse("Lost message while saving [" + this.message.getMessageUID() + "]");
            logger.error((Object)("Lost message while saving [" + this.message.getMessageUID() + "]"), (Throwable)e);
        }
        return response;
    }

    private boolean filter() {
        String className = ResourceBundle.getBundle(BUNDLE_NAME).getString("class");
        return this.command.getClass().getName().equals(className);
    }
}

