/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.messageprocessor;

import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.messageprocessor.CommandException;
import com.tandbergtv.workflow.util.ExtensionClassLoaderUtil;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class CommandManager {
    private static Logger logger = Logger.getLogger(CommandManager.class);
    private static final String BUNDLE_NAME = String.valueOf(CommandManager.class.getPackage().getName()) + ".command";

    public static WorkflowMessage createAndExecute(WorkflowMessage message) {
        WorkflowMessage response = null;
        ICommand cmd = CommandManager.getCommand(message);
        try {
            logger.debug((Object)("Executing command : " + cmd.getClass().getSimpleName()));
            response = CommandManager.getDecoratedCommand(cmd).execute();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command for message " + message.getMessageUID(), e);
        }
        return response;
    }

    public static ICommand getCommand(WorkflowMessage message) {
        ICommand cmd = null;
        WPCLCommand command = WPCLCommand.NULL;
        if (message.getCommand() != null) {
            command = message.getCommand();
        }
        try {
            String className = ResourceBundle.getBundle(BUNDLE_NAME).getString(command.getName().toLowerCase());
            Class clazz = ExtensionClassLoaderUtil.loadClass(className);
            Constructor ctor = clazz.getConstructor(WorkflowMessage.class);
            cmd = (ICommand)ctor.newInstance(message);
        }
        catch (Exception e) {
            throw new CommandException("Could not get command for message " + message.getMessageUID(), e);
        }
        return cmd;
    }

    private static ICommand getDecoratedCommand(ICommand command) {
        ICommand cmd = null;
        try {
            String className = ResourceBundle.getBundle(BUNDLE_NAME).getString("decorator");
            Class clazz = ExtensionClassLoaderUtil.loadClass(className);
            Constructor ctor = clazz.getConstructor(ICommand.class);
            cmd = (ICommand)ctor.newInstance(command);
        }
        catch (Exception e) {
            throw new CommandException("Failed to load decorator", e);
        }
        return cmd;
    }
}

