/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.health.IHealthAware;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.List;

public interface ResourceManagement
extends IHealthAware,
Service {
    public static final String HUMAN_RESOURCE_SYSTEM_ID = "04";
    public static final String PMM_RESOURCE_SYSTEM_ID = "PM";

    public List<ResourceType> getAllResourceTypes();

    public ResourceType getResourceType(long var1) throws FinderException;

    public List<ResourceGroup> getAllResourceGroups();

    public ResourceGroup getResourceGroup(long var1) throws FinderException;

    public List<ResourceGroup> getResourceGroupsByResourceType(long var1);

    public List<ResourceGroup> getResourceGroupsByResource(long var1);

    public ResourceGroup getResourceGroupByToken(long var1);

    public List<Resource> getAllResources();

    public List<Resource> getResourcesBySearchCriteria(SearchCriteria var1) throws DataOperationException;

    public int getActiveResourcesCount();

    public Resource getResource(long var1) throws FinderException, DataOperationException;

    public List<Resource> getResourcesByResourceType(long var1);

    public List<Resource> getResourcesByGroup(long var1);

    public Resource getResourceByToken(long var1);

    public Resource getResourceByUser(String var1);

    public Resource getResourceByConnectionString(String var1);

    public Resource getResourceByConnectionString(String var1, long var2);

    public Resource setResourceOnline(long var1) throws FinderException, DataOperationException, ValidationException;

    public Resource setResourceOffline(long var1) throws FinderException, DataOperationException;

    public Resource createResource(Resource var1) throws ValidationException, DataOperationException, FinderException;

    public Resource updateResource(Resource var1) throws ValidationException, ActionException, FinderException, DataOperationException;

    public boolean deleteResource(long var1) throws ActionException, FinderException, DataOperationException;

    public boolean isResourceAvailable(long var1);

    public ResourceGroup moveQueueItemToTop(long var1, long var3) throws ActionException, FinderException;

    public ResourceGroup moveQueueItemToBottom(long var1, long var3) throws ActionException, FinderException;

    public ResourceGroup moveQueueItemUp(long var1, long var3, long var5) throws ActionException, FinderException;

    public ResourceGroup moveQueueItemDown(long var1, long var3, long var5) throws ActionException, FinderException;

    public void setResourceGroupQueueUIVisibility(long var1, boolean var3) throws FinderException, DataOperationException;

    public IAllocationKeyService getAllocationKeyService();
}

