/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerContext;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.util.ResourceValidator;
import java.util.ArrayList;

final class ResourceManagerValidator {
    private static final String DELETE_OPERATION = "delete";
    private static final String UPDATE_OPERATION = "update";
    private static final String SYSTEM_RESOURCES = "systemResources";
    private static final String HUMAN_RESOURCE = "humanResource";
    private ResourceManagerContext context;

    ResourceManagerValidator(ResourceManagerContext context) {
        this.context = context;
    }

    void validateResourceProperties(Resource resource) throws ValidationException {
        ResourceValidator.validateResource(resource);
        ArrayList<String> errorList = new ArrayList<String>();
        String name = resource.getName();
        for (ResourceContainer container : this.context.resources.values()) {
            Resource containedResource = container.getResource();
            if (containedResource.equals(resource) || !name.equals(containedResource.getName())) continue;
            errorList.add("VR-200");
            break;
        }
        if (resource.getId() != -1L) {
            ResourceContainer container;
            container = this.context.resources.get(resource.getId());
            Resource containedResource = container.getResource();
            if (!resource.getResourceType().equals(containedResource.getResourceType())) {
                errorList.add("VR-201");
            }
        } else {
            long resourceTypeId = resource.getResourceType().getId();
            if (!this.context.resourceTypes.containsKey(resourceTypeId)) {
                errorList.add("VR-204");
            }
        }
        String connectionString = resource.getConnectionString();
        for (ResourceContainer resourceContainer : this.context.resources.values()) {
            Resource otherResource = resourceContainer.getResource();
            if (resource.equals(otherResource) || !connectionString.equals(otherResource.getConnectionString())) continue;
            errorList.add("VR-202");
            break;
        }
        if (errorList.size() > 0) {
            ValidationException ve = new ValidationException();
            ve.setErrorCodes(errorList);
            throw ve;
        }
    }

    void validateResourceForModification(long resourceId, boolean isUpdate) throws ActionException, FinderException {
        boolean validAdminState;
        String operation;
        ResourceContainer container = this.context.resources.get(resourceId);
        String string = operation = isUpdate ? UPDATE_OPERATION : DELETE_OPERATION;
        if (container == null) {
            String msg = "Could not " + operation + " Resource with id=" + resourceId + ", no such Resource exists.";
            throw new FinderException(msg);
        }
        Resource resource = container.getResource();
        if (resource.getUserCount() != 0) {
            int userCount = resource.getUserCount();
            String msg = "Could not " + operation + " Resource: " + resource.getName() + ", the Resource currently has " + userCount + " users.";
            throw new ActionException(msg, "AE-100");
        }
        boolean validOpState = ResourceState.OFFLINE == resource.getOperationalState() || ResourceState.INACTIVE == resource.getOperationalState() && !isUpdate || ResourceState.INVALID == resource.getOperationalState() && !isUpdate;
        boolean bl = validAdminState = ResourceState.OFFLINE == resource.getAdministrationState() || ResourceState.INACTIVE == resource.getOperationalState() && !isUpdate || ResourceState.INVALID == resource.getOperationalState() && !isUpdate;
        if (!validOpState) {
            String msg = "Could not " + operation + " Resource: " + resource.getName() + ", the Operational State is not Offline.";
            throw new ActionException(msg, "AE-102");
        }
        if (!validAdminState) {
            String msg = "Could not " + operation + " Resource: " + resource.getName() + ", the Administration State is not Offline.";
            throw new ActionException(msg, "AE-103");
        }
    }

    int getNumOfLicResources(String resourceCategory) throws InvalidLicenseException {
        int result = -1;
        LicenseManager licManager = LicenseManager.getInstance();
        String resourceEntry = licManager.getObject(resourceCategory);
        if (resourceEntry == null || resourceEntry.trim().length() == 0) {
            return Integer.MAX_VALUE;
        }
        result = Integer.parseInt(resourceEntry.trim());
        if (result < 0) {
            throw new InvalidLicenseException("Invalid License for " + resourceCategory + " - non-negative value must be specified");
        }
        return result;
    }

    void checkLicense(Resource resource) throws ValidationException {
        ValidationException ve = new ValidationException();
        if (resource == null) {
            ve.addErrorCode("VR-100");
            throw ve;
        }
        String systemId = resource.getResourceType().getSystemId();
        if (systemId.equals("PM")) {
            return;
        }
        int availSystemRes = 0;
        int availHumanRes = 0;
        try {
            availSystemRes = this.getNumOfLicResources(SYSTEM_RESOURCES);
            availHumanRes = this.getNumOfLicResources(HUMAN_RESOURCE);
        }
        catch (InvalidLicenseException e) {
            ve.addErrorCode("VR-300");
            throw ve;
        }
        int sysResCount = this.context.getNumOfActiveSystemResources();
        int humanResCount = this.context.getNumOfActiveHumanResources();
        if (systemId.equals("04")) {
            if (humanResCount >= availHumanRes) {
                ve.addErrorCode("VR-301");
                throw ve;
            }
        } else if (sysResCount >= availSystemRes) {
            ve.addErrorCode("VR-302");
            throw ve;
        }
    }
}

