/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.entities;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueue;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.util.HashSet;
import java.util.Set;

public class ResourceGroup
implements ResourceEntity {
    private static final long serialVersionUID = 1285262482920125179L;
    private long id = -1L;
    private String name;
    private boolean internallyAcquired = true;
    private ResourceType resourceType;
    private int protectionKeyId = -1;
    private ResourceGroupQueue queue = new ResourceGroupQueue(this);
    private Set<Resource> resources = new HashSet<Resource>();
    private String functionalType;
    private boolean visible;
    private static final int HASHCODE_MULTIPLICATION_FACTOR = 13;
    private static final int HASHCODE_ADDITION_FACTOR = 841;

    public ResourceGroup() {
    }

    public ResourceGroup(long resourceGroupId) {
        this.id = resourceGroupId;
    }

    public String getFunctionalType() {
        return this.functionalType;
    }

    public void setFunctionalType(String functionalType) {
        this.functionalType = functionalType;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isInternallyAcquired() {
        return this.internallyAcquired;
    }

    public void setInternallyAcquired(boolean internallyAcquired) {
        this.internallyAcquired = internallyAcquired;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public void removeAllResources() {
        this.resources.clear();
    }

    public void addResource(Resource resource) {
        if (resource != null && !this.resources.contains(resource)) {
            this.resources.add(resource);
        }
    }

    public void removeResource(Resource resource) {
        this.resources.remove(resource);
    }

    public ResourceGroupQueue getQueue() {
        return this.queue;
    }

    public void setQueue(ResourceGroupQueue queue) {
        this.queue = queue;
        if (queue != null) {
            queue.setResourceGroup(this);
        }
    }

    public int getProtectionKeyId() {
        return this.protectionKeyId;
    }

    public void setProtectionKeyId(int protectionKeyId) {
        this.protectionKeyId = protectionKeyId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceGroup) {
            ResourceGroup resObj = (ResourceGroup)obj;
            if (resObj.getId() != -1L && this.getId() != -1L) {
                return resObj.getId() == this.getId();
            }
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        long hash = this.id * 13L + 841L;
        int hashCode = new Long(hash).hashCode();
        if (this.id == -1L) {
            hashCode = super.hashCode();
        }
        return hashCode;
    }

    @Override
    public Object clone() {
        ResourceGroup clone = null;
        try {
            clone = (ResourceGroup)super.clone();
            if (this.resourceType != null) {
                clone.resourceType = (ResourceType)this.resourceType.clone();
            }
            if (this.resources != null) {
                clone.resources = new HashSet<Resource>(this.resources);
            }
            if (this.queue != null) {
                ResourceGroupQueue cloneQueue = (ResourceGroupQueue)this.queue.clone();
                clone.setQueue(cloneQueue);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " | " + this.getResourceType() + " | " + this.getFunctionalType() + " | " + this.getProtectionKeyId();
    }
}

