/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.table;

import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableExtensionBuilder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableConfig
implements Serializable {
    private static TableConfig tableCofig = null;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TableConfig.class);
    private static final String TABLE_CONFIG_FILE_NAME = "table-config.xml";
    private static String TABLE_TAG_NAME = "table";
    private static String TABLE_ID = "id";
    private static final String DEFAULT_SORTING_COLUMN_NAME = "defaultSortingColumn";
    private static final String DEFAULT_SORTING_ORDER = "defaultSortingOrder";
    private static final String ACTION_PATH = "actionPath";
    private static final String DEFAULT_COLUMN_WIDTH = "defaultColumnWidth";

    private TableConfig() {
    }

    public static synchronized TableConfig getInstance() {
        if (tableCofig == null) {
            tableCofig = new TableConfig();
        }
        return tableCofig;
    }

    public Table getTable(String tableId) {
        return this.getTable(tableId, null);
    }

    public Table getTable(String tableId, Map<String, String> runtimeProperties) {
        Map<String, Table> tables = this.getTables();
        Table table = tables.get(tableId);
        TableExtensionBuilder extensionBuilder = new TableExtensionBuilder();
        extensionBuilder.buildTable(table, runtimeProperties);
        return table;
    }

    private Map<String, Table> getTables() {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        NodeList nodes = this.getNodes();
        if (nodes == null) {
            return tables;
        }
        int i = 0;
        while (i < nodes.getLength()) {
            Table table = this.getTable(nodes.item(i));
            tables.put(table.getId(), table);
            ++i;
        }
        for (String tableId : tables.keySet()) {
            logger.debug((Object)("Table Name-->" + tableId));
            for (Column column : ((Table)tables.get(tableId)).getColumns()) {
                logger.debug((Object)("maps-->" + column.getColumnAttributesMap()));
            }
        }
        return tables;
    }

    private NodeList getNodes() {
        NodeList nodes = null;
        try {
            String dir = ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath");
            String filename = String.valueOf(dir) + System.getProperty("file.separator") + TABLE_CONFIG_FILE_NAME;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(filename));
            nodes = document.getDocumentElement().getElementsByTagName(TABLE_TAG_NAME);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the table configuration file", (Throwable)e);
        }
        return nodes;
    }

    private Table getTable(Node node) {
        Table table = new Table();
        NamedNodeMap attributes = node.getAttributes();
        table.setId(attributes.getNamedItem(TABLE_ID).getNodeValue());
        table.setDefaultSortingColumn(attributes.getNamedItem(DEFAULT_SORTING_COLUMN_NAME).getNodeValue());
        table.setDefaultSortingOrder(attributes.getNamedItem(DEFAULT_SORTING_ORDER).getNodeValue());
        table.setActionPath(attributes.getNamedItem(ACTION_PATH).getNodeValue());
        table.setDefaultColumnWidth(attributes.getNamedItem(DEFAULT_COLUMN_WIDTH).getNodeValue());
        ArrayList<Column> columns = new ArrayList<Column>();
        if (node.hasChildNodes()) {
            NodeList columnNodeList = node.getChildNodes();
            int j = 0;
            while (j < columnNodeList.getLength()) {
                NodeList columnParams = columnNodeList.item(j).getChildNodes();
                if (columnParams.getLength() > 0) {
                    Column column = new Column();
                    HashMap<String, String> map = new HashMap<String, String>();
                    int k = 0;
                    while (k < columnParams.getLength()) {
                        Node n = columnParams.item(k);
                        NodeList children = n.getChildNodes();
                        int l = 0;
                        while (l < children.getLength()) {
                            map.put(n.getNodeName(), children.item(l).getNodeValue());
                            ++l;
                        }
                        ++k;
                    }
                    column.setColumnAttributesMap(map);
                    columns.add(column);
                }
                ++j;
            }
            table.setColumns(columns);
        }
        return table;
    }
}

