/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.table;

import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.ITableExtensionLoader;
import com.tandbergtv.workflow.web.table.Table;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableExtensionBuilder {
    private static final String TABLE_EXTENSION_ATTRIBUTE = "TableExtensionKey";
    private static final String TABLE_EXTENSION_LOADER_IMPL_ATTRIBUTE = "TableExtensionLoaderImpl";

    public void buildTable(Table table, Map<String, String> runtimeProperties) {
        if (table == null) {
            return;
        }
        if (runtimeProperties == null) {
            runtimeProperties = new HashMap<String, String>();
        }
        String tableName = table.getId();
        ArrayList<Column> replacedColumns = new ArrayList<Column>();
        for (Column column : table.getColumns()) {
            String key = column.getColumnAttribute(TABLE_EXTENSION_ATTRIBUTE);
            if (key != null) {
                ITableExtensionLoader loader = this.getExtensionLoader(column, tableName, key);
                List<Column> extendedColumns = loader.loadExtension(key, runtimeProperties);
                if (extendedColumns == null) continue;
                this.updateColumnWidths(column, extendedColumns);
                replacedColumns.addAll(extendedColumns);
                continue;
            }
            replacedColumns.add(column);
        }
        table.setColumns(replacedColumns);
    }

    private ITableExtensionLoader getExtensionLoader(Column column, String tableName, String extensionKey) {
        String extensionImpl = column.getColumnAttribute(TABLE_EXTENSION_LOADER_IMPL_ATTRIBUTE);
        try {
            Class<?> clazz = Class.forName(extensionImpl);
            Object instance = clazz.newInstance();
            return (ITableExtensionLoader)ITableExtensionLoader.class.cast(instance);
        }
        catch (Exception e) {
            String msg = "Failed to load ITableExtensionLoader implementation: " + extensionImpl + " when building table[" + tableName + ", " + extensionKey + "].";
            throw new RuntimeException(msg, e);
        }
    }

    private void updateColumnWidths(Column extensionColumn, List<Column> extendedColumns) {
        String widthValue = extensionColumn.getWidth();
        if (widthValue == null) {
            widthValue = "";
        }
        double width = 1.0;
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(0);
        try {
            width = format.parse(widthValue.trim()).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Column column : extendedColumns) {
            String columnWidthValue = column.getColumnAttribute("Width");
            if (columnWidthValue == null) continue;
            try {
                double columnWidth = format.parse(columnWidthValue.trim()).doubleValue();
                columnWidth = Math.floor(columnWidth * width * 100.0) / 100.0;
                column.setColumnAttribute("Width", format.format(columnWidth));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

