/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.search;

import com.tandbergtv.watchpoint.search.HQLQuery;
import com.tandbergtv.watchpoint.search.Join;
import com.tandbergtv.watchpoint.search.SearchParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import java.util.ArrayList;
import java.util.List;

public class Entity
extends SearchParameter {
    protected List<SearchParameter> subparameters;
    protected Class<?> clazz;
    protected String property;
    protected boolean fetch;
    protected Join join;

    public Entity(String name, Class<?> clazz, String alias) {
        super(name);
        this.clazz = clazz;
        this.subparameters = new ArrayList<SearchParameter>();
        this.alias = alias;
        this.fetch = true;
        this.join = Join.INNER;
    }

    public Entity(String name, String property, String alias) {
        super(name);
        this.property = property;
        this.subparameters = new ArrayList<SearchParameter>();
        this.alias = alias;
        this.join = Join.INNER;
    }

    public Class<?> getEntityClass() {
        return this.clazz;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    public Join getJoin() {
        return this.join;
    }

    public void setJoin(Join join) {
        this.join = join;
    }

    public List<SearchParameter> getSubParameters() {
        return this.subparameters;
    }

    public String getSelectClause() {
        if (!this.fetch) {
            return "";
        }
        String clause = this.getCompleteAlias();
        for (SearchParameter subparameter : this.getSubParameters()) {
            Entity e;
            if (!(subparameter instanceof Entity) || !(e = (Entity)Entity.class.cast(subparameter)).isFetch()) continue;
            clause = clause + ", " + e.getCompleteAlias();
        }
        return clause;
    }

    @Override
    public String getPartialFromClause(int count) {
        String clause = "";
        this.setObjectCount(count);
        for (SearchParameter subparameter : this.subparameters) {
            String partialWhere;
            if (!(subparameter instanceof Entity)) continue;
            Entity e = (Entity)Entity.class.cast(subparameter);
            String name = this.getCompleteAlias() + (Object)((Object)HQLQuery.PERIOD) + e.getProperty();
            HQLQuery jointype = e.getJoin() == Join.INNER ? HQLQuery.INNER_JOIN : HQLQuery.LEFT_JOIN;
            clause = clause + System.getProperty("line.separator");
            clause = clause + (Object)((Object)jointype) + name + " " + e.getCompleteAlias();
            if (e.getJoin() != Join.LEFT_OUTER || (partialWhere = e.getPartialWhereClause()).length() <= 0) continue;
            clause = clause + (Object)((Object)HQLQuery.WITH) + partialWhere;
        }
        return this.clazz.getName() + " " + this.alias + this.objectCount + clause;
    }

    @Override
    public String getPartialWhereClause() {
        String clause = "";
        for (SearchParameter subparameter : this.subparameters) {
            Entity e;
            if (subparameter.getDecoratedParameter() instanceof SortParameter || subparameter instanceof Entity && (e = (Entity)Entity.class.cast(subparameter)).getJoin() == Join.LEFT_OUTER) continue;
            if (clause.length() > 0) {
                clause = clause + System.getProperty("line.separator") + "\t" + (Object)((Object)HQLQuery.AND);
            }
            clause = clause + subparameter.getPartialWhereClause();
        }
        return clause;
    }

    @Override
    public String getPartialOrderByClause() {
        String clause = "";
        for (SearchParameter parameter : this.getSubParameters()) {
            if (parameter instanceof Entity) {
                clause = clause + parameter.getPartialOrderByClause();
                continue;
            }
            if (!(parameter.getDecoratedParameter() instanceof SortParameter)) continue;
            if (clause.length() > 0) {
                clause = clause + ", ";
            }
            clause = clause + this.getCompleteAlias() + (Object)((Object)HQLQuery.PERIOD) + parameter.getPartialOrderByClause();
        }
        return clause;
    }

    @Override
    public void setObjectCount(int count) {
        this.objectCount = count;
        for (SearchParameter subparameter : this.subparameters) {
            if (subparameter instanceof Entity) {
                subparameter.setObjectCount(count++);
                continue;
            }
            subparameter.setObjectCount(this.objectCount);
        }
    }

    public void addParameter(SearchParameterBase parameter) {
        SearchParameter subparameter = null;
        if (parameter instanceof SearchParameter) {
            subparameter = (SearchParameter)parameter;
        } else {
            subparameter = new SearchParameter(parameter);
            subparameter.setAlias(this.alias);
        }
        this.subparameters.add(subparameter);
    }
}

