/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentUtility {
    public static void setNodeValue(String expression, String value, XPath xPath, Node n) throws Exception {
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        node.setTextContent(value);
    }

    public static String getNodeValue(String expression, XPath xPath, Node n) throws Exception {
        if (expression.substring(0, 1).equals("$")) {
            return expression.substring(1);
        }
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        if (node != null) {
            return node.getTextContent();
        }
        return "";
    }

    public static NodeList getNodeSet(String expression, XPath xPath, Document doc) throws Exception {
        return (NodeList)xPath.evaluate(expression, doc, XPathConstants.NODESET);
    }

    public static String convertToString(Document document) throws Exception {
        StringWriter w = new StringWriter();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document.getDocumentElement()), new StreamResult(w));
        return w.getBuffer().toString();
    }

    public static Document loadXml(String xmlString) throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlString.getBytes()));
    }

    public static Document loadFile(ClassLoader classloader, String filePath, boolean validating) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        InputStream stream = classloader.getResourceAsStream(filePath);
        return factory.newDocumentBuilder().parse(stream);
    }

    public static Document loadFile(String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(XMLDocumentUtility.class.getClassLoader(), filePath);
    }

    public static Document loadFile(ClassLoader classloader, String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(classloader, filePath, false);
    }

    public static Schema loadSchema(String path) throws Exception {
        InputStream stream = XMLDocumentUtility.class.getClassLoader().getResourceAsStream(path);
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
    }

    public static void save(Document document, String filePath) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(new File(filePath)));
    }
}

