/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.metadatamanager.model.Item;
import java.util.ArrayList;

public class File
extends Item {
    public File() {
        this.setType(Item.ItemType.FILE);
    }

    @Override
    public void addField(Field field) {
        if (field.getIndices() == null || field.getIndices().size() == 0) {
            String[] a = field.getTtvXPath().split("/");
            if (a.length == 0) {
                throw new IllegalArgumentException("Field (" + field + ") has invalid name");
            }
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (String s : a) {
                if (s.equals("") || s.startsWith("@")) continue;
                indices.add(new Integer(1));
            }
            field.setIndices(indices);
        }
        super.addField(field);
    }

    public boolean isOriginal() {
        Field field = this.getFirstField(FieldName.TYPE.toString());
        if (field != null) {
            return FileType.ORIGINAL.toString().equals(field.getValue());
        }
        return false;
    }

    public void setFileType(FileType fileType) {
        Field field = this.getFirstField(FieldName.TYPE.toString());
        if (field == null) {
            field = new Field(FieldName.TYPE.toString(), null);
            this.addField(field);
        }
        field.setValue(fileType.toString());
    }

    public String getURL() {
        return (String)this.getFieldValue(FieldName.FILE_URL.toString());
    }

    public String getName() {
        return (String)this.getFieldValue(FieldName.FILE_NAME.toString());
    }

    public String getMIMEType() {
        return (String)this.getFieldValue(FieldName.MIME_TYPE.toString());
    }

    public String getResolution() {
        return (String)this.getFieldValue(FieldName.RESOLUTION.toString());
    }

    public String getSize() {
        Object value = this.getFieldValue(FieldName.FILE_SIZE.toString());
        if (value == null) {
            return "0";
        }
        return (String)value;
    }

    public int getWidth() {
        Object value = this.getFieldValue(FieldName.WIDTH.toString());
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    public int getHeight() {
        Object value = this.getFieldValue(FieldName.HEIGHT.toString());
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    public String getDuration() {
        return (String)this.getFieldValue(FieldName.DURATION.toString());
    }

    public String getBitrate() {
        return (String)this.getFieldValue(FieldName.BITRATE.toString());
    }

    public String getAspectratio() {
        return (String)this.getFieldValue(FieldName.ASPECTRATIO.toString());
    }

    public String getChecksum() {
        return (String)this.getFieldValue(FieldName.FILE_CHECKSUM.toString());
    }

    private Object getFieldValue(String path) {
        Field field = this.getFirstField(path);
        if (field != null) {
            return field.getTypedValue();
        }
        return null;
    }
}

