/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.FieldSearchKey;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.builder.JoinOperator;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.search.builder.QueryOperators;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.List;

public class ListFieldInfo
extends FieldInfo {
    LogicalOperator operator;
    List<String> values;

    public ListFieldInfo() {
        this.operator = LogicalOperator.IN;
        this.isConjunction = true;
    }

    public ListFieldInfo(String ttvxpath, List<String> values) {
        this.ttvxpath = ttvxpath;
        this.operator = LogicalOperator.IN;
        this.values = values;
        this.isConjunction = true;
    }

    public ListFieldInfo(String ttvxpath, List<String> values, LogicalOperator operator, String assetType) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.values = values;
        this.isConjunction = true;
        this.assetType = assetType;
    }

    public ListFieldInfo(String ttvxpath, List<String> values, LogicalOperator operator, boolean isConjunction) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.values = values;
        this.isConjunction = isConjunction;
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    @Override
    public String getCondition(String alias) {
        StringBuilder fieldConditions = new StringBuilder();
        fieldConditions.append(alias + QueryConstants.PERIOD + (Object)((Object)FieldSearchKey.TTV_XPATH) + QueryOperators.EQUAL.toString() + QueryConstants.QUOTE + this.getTtvxpath() + QueryConstants.QUOTE);
        fieldConditions.append(QueryConstants.SPACE);
        fieldConditions.append((Object)JoinOperator.AND);
        fieldConditions.append(QueryConstants.SPACE);
        String valueColumnName = this.getValueColumnName();
        SearchType searchType = SearchType.STRING;
        searchType = this.getSearchTypeBasedOnColumn(valueColumnName);
        StringBuilder allValues = new StringBuilder();
        for (String value : this.values) {
            if (allValues.length() > 0) {
                allValues.append(",");
            }
            if (searchType == SearchType.STRING) {
                allValues.append(QueryConstants.QUOTE + value + QueryConstants.QUOTE);
                continue;
            }
            allValues.append(value);
        }
        fieldConditions.append(alias + QueryConstants.PERIOD + valueColumnName + QueryConstants.SPACE + QueryOperators.lookUp(this.operator.toString()) + QueryConstants.SPACE + QueryConstants.START_PARENTHESIS + allValues.toString() + QueryConstants.END_PARENTHESIS);
        return fieldConditions.toString();
    }

    @Override
    public String getSelectProperties() {
        return "";
    }
}

