/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.showtime.action;

import com.tandbergtv.showtime.action.util.ActionProperties;
import com.tandbergtv.showtime.util.PathConverter;
import java.io.File;
import java.util.Random;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class InitializeVariablesAction
implements ActionHandler {
    private static final long serialVersionUID = -8690377967308890445L;
    private static final String MPEG_EXTENSION = ".mpg";
    private static final String ENCODER_PROFILE_NAME_PROPERTY = "XPortProducer.ProfileName";
    private final String PERFORM_QC = "PerformQC";

    public void execute(ExecutionContext context) throws Exception {
        String filePath = this.getStringValue(context, "filePath");
        File assetFile = new File(filePath);
        String fileName = assetFile.getName();
        int index = fileName.lastIndexOf(".");
        String baseFileName = index != -1 ? fileName.substring(0, index) : fileName;
        String reencodedFileName = baseFileName + MPEG_EXTENSION;
        String contentFolderPath = ActionProperties.getString("NAS.ContentFolderPath");
        String originalSubFolderPath = ActionProperties.getString("NAS.OriginalSubFolderPath");
        String reencodedSubFolderPath = ActionProperties.getString("NAS.ReEncodedSubFolderPath");
        File nasContentFolder = new File(contentFolderPath);
        File originalFolder = new File(nasContentFolder, originalSubFolderPath);
        File reencodedFolder = new File(nasContentFolder, reencodedSubFolderPath);
        String originalFilePath = new File(originalFolder, fileName).getAbsolutePath();
        String reencodedFilePath = new File(reencodedFolder, reencodedFileName).getAbsolutePath();
        PathConverter pathConverter = PathConverter.getInstance();
        String inputFileUNCPath = pathConverter.convertUnixToUNC(filePath);
        String originalFileUNCPath = pathConverter.convertUnixToUNC(originalFilePath);
        String reencodedFileUNCPath = pathConverter.convertUnixToUNC(reencodedFilePath);
        String profileName = ActionProperties.getString(ENCODER_PROFILE_NAME_PROPERTY);
        String performQC = ActionProperties.getString(this.PERFORM_QC);
        Random r = new Random();
        boolean qcRequired = false;
        Double randomValue = r.nextDouble();
        if (randomValue.intValue() * 100 < new Double(performQC).intValue()) {
            qcRequired = true;
        }
        context.setVariable("fileName", (Object)fileName);
        context.setVariable("fileUNCPath", (Object)inputFileUNCPath);
        context.setVariable("nasFilePath", (Object)originalFilePath);
        context.setVariable("nasFileUNCPath", (Object)originalFileUNCPath);
        context.setVariable("nasFileUNCPathString", (Object)originalFileUNCPath);
        context.setVariable("reencodedFilePath", (Object)reencodedFilePath);
        context.setVariable("reencodedFileUNCPath", (Object)reencodedFileUNCPath);
        context.setVariable("reencodedFileUNCPathString", (Object)reencodedFileUNCPath);
        context.setVariable("encodingProfile", (Object)profileName);
        context.setVariable("QCRequired", (Object)qcRequired);
        context.setVariable("PerformQC", (Object)(performQC + "%"));
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }
}

