/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.showtime.action;

import com.tandbergtv.showtime.action.util.ArchiveUtility;
import com.tandbergtv.showtime.util.PathConverter;
import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;

public class UntarAction
implements ActionHandler {
    private static final long serialVersionUID = -341236923644501661L;
    private static Logger logger = Logger.getLogger(UntarAction.class);
    private static String PACKAGE_ASSET_ID_XPATH = "//AMS[@Asset_Class='package']/@Asset_ID";
    private static String MOVIE_ASSET_XPATH = "//Asset[Metadata/AMS[@Asset_Class='movie']]/Content/@Value";

    public void execute(ExecutionContext context) throws Exception {
        String packagePath = this.getStringValue(context, "originalPath");
        String packageName = this.getStringValue(context, "fileName");
        de.schlichtherle.io.File VODPackage = new de.schlichtherle.io.File(packagePath, packageName);
        context.setVariable("originalPath", (Object)VODPackage.getAbsolutePath());
        String stagingPath = this.getStringValue(context, "stagingPath");
        de.schlichtherle.io.File stagingFolder = new de.schlichtherle.io.File(stagingPath);
        de.schlichtherle.io.File archive = ArchiveUtility.openArchive(VODPackage.getAbsolutePath());
        try {
            logger.info((Object)(" Extracting package to " + stagingFolder.getAbsolutePath()));
            archive.copyAllTo((File)stagingFolder);
            logger.info((Object)" Package extracted");
        }
        catch (Exception ex) {
            context.setVariable("processFailureReason", (Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (archive != null) {
                ArchiveUtility.closeArchive(archive);
            }
        }
        this.parseMetadata((File)stagingFolder, context);
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }

    private void parseMetadata(File folder, ExecutionContext context) throws Exception {
        String metadataFilePath = "";
        if (folder.isDirectory()) {
            File[] fileList = folder.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                de.schlichtherle.io.File f = (de.schlichtherle.io.File)fileList[i];
                logger.info((Object)("Reading Files : " + f.getName()));
                if (!f.getName().equalsIgnoreCase("ADI.XML")) continue;
                metadataFilePath = f.getAbsolutePath();
                context.setVariable("metadataPath", (Object)metadataFilePath);
                break;
            }
        }
        logger.info((Object)("Metadata file path = " + metadataFilePath));
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(metadataFilePath));
        XPath xpath = XPathFactory.newInstance().newXPath();
        String packageAssetID = xpath.evaluate(PACKAGE_ASSET_ID_XPATH, doc);
        if (packageAssetID != null) {
            context.setVariable("packageAssetID", (Object)packageAssetID);
        }
        String movieAssetName = xpath.evaluate(MOVIE_ASSET_XPATH, doc);
        logger.info((Object)(" Movie asset name in ADI.xml = +" + movieAssetName + "+"));
        boolean movieAssetPresent = false;
        if (movieAssetName != null && !movieAssetName.trim().equals("")) {
            movieAssetPresent = true;
            context.setVariable("hasMovieAsset", (Object)movieAssetPresent);
            File movieFile = new File(folder, movieAssetName);
            context.setVariable("movieFilePath", (Object)movieFile.getAbsolutePath());
            String movieFileUNC = PathConverter.getInstance().convertUnixToUNC(movieFile.getAbsolutePath());
            logger.info((Object)(" Movie File path " + movieFileUNC));
            context.setVariable("movieFilePathUNC", (Object)movieFileUNC);
            String encodedPath = this.getStringValue(context, "encodedPath");
            String movieName = movieFile.getName();
            File encodedFile = new File(encodedPath, movieName);
            String encodedFileUNC = PathConverter.getInstance().convertUnixToUNC(encodedFile.getAbsolutePath());
            context.setVariable("encodedPath", (Object)encodedFile.getAbsolutePath());
            context.setVariable("encodedPathUNC", (Object)encodedFileUNC);
            context.setVariable("encodedPathString", (Object)encodedFileUNC);
        }
    }
}

