/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.showtime.action;

import com.tandbergtv.showtime.action.util.ActionProperties;
import java.io.File;
import java.util.Random;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class VODProcessInitializeVariablesAction
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private String ROOT_FOLDER = "NAS.ContentFolderPath";
    private String ORIGINAL_FOLDER = "NAS.OriginalSubFolderPath";
    private String STAGING_FOLDER = "NAS.StagingSubFolderPath";
    private String REENCODED_FOLDER = "NAS.ReEncodedSubFolderPath";
    private String DISTRIBUTION_FOLDER = "NAS.DistributionSubFolderPath";
    private String ENCODING_PROFILE = "XPortProducer.ProfileName";
    private final String PERFORM_QC = "PerformQC";
    private static Logger logger = Logger.getLogger(VODProcessInitializeVariablesAction.class);

    public void execute(ExecutionContext context) throws Exception {
        String inputPath = this.getStringValue(context, "filePath");
        long tokenID = context.getProcessInstance().getId();
        String rootPath = ActionProperties.getString(this.ROOT_FOLDER);
        File inputFile = new File(inputPath);
        String inputFileName = inputFile.getName();
        context.setVariable("fileName", (Object)inputFileName);
        String originalSubFolder = ActionProperties.getString(this.ORIGINAL_FOLDER) + "/" + tokenID;
        File originalFolder = new File(rootPath, originalSubFolder);
        this.createFolder(originalFolder, context);
        String stagingSubFolder = ActionProperties.getString(this.STAGING_FOLDER) + "/" + tokenID;
        File stagingFolder = new File(rootPath, stagingSubFolder);
        this.createFolder(stagingFolder, context);
        String distributionSubFolder = ActionProperties.getString(this.DISTRIBUTION_FOLDER) + "/" + tokenID;
        File distributionFolder = new File(rootPath, distributionSubFolder);
        this.createFolder(distributionFolder, context);
        String encodedSubFolder = ActionProperties.getString(this.REENCODED_FOLDER) + "/" + tokenID;
        File encodedFolder = new File(rootPath, encodedSubFolder);
        this.createFolder(encodedFolder, context);
        String performQC = ActionProperties.getString(this.PERFORM_QC);
        Random r = new Random();
        boolean qcRequired = false;
        Double randomValue = r.nextDouble();
        logger.info((Object)("Random value = " + randomValue));
        if (randomValue.intValue() * 100 < new Double(performQC).intValue()) {
            qcRequired = true;
        }
        String encodingProfile = ActionProperties.getString(this.ENCODING_PROFILE);
        context.setVariable("originalPath", (Object)originalFolder.getAbsolutePath());
        context.setVariable("stagingPath", (Object)stagingFolder.getAbsolutePath());
        context.setVariable("encodedPath", (Object)encodedFolder.getAbsolutePath());
        context.setVariable("distributionPath", (Object)distributionFolder.getAbsolutePath());
        context.setVariable("encodingProfile", (Object)encodingProfile);
        context.setVariable("performQC", (Object)(performQC + "%"));
        context.setVariable("QCRequired", (Object)qcRequired);
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }

    private void createFolder(File folder, ExecutionContext context) throws Exception {
        block4: {
            try {
                if (!folder.mkdir()) break block4;
                logger.info((Object)("Directory created " + folder.getAbsolutePath()));
                try {
                    Runtime.getRuntime().exec("chmod 777 " + folder);
                }
                catch (Exception ex) {
                    context.setVariable("processFailureReason", (Object)ex.getMessage());
                    throw ex;
                }
            }
            catch (Exception ex) {
                context.setVariable("processFailureReason", (Object)ex.getMessage());
                throw ex;
            }
        }
    }
}

