/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.showtime.action;

import com.tandbergtv.showtime.action.util.ArchiveUtility;
import java.io.File;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class TarAction
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(TarAction.class);

    public void execute(ExecutionContext context) throws Exception {
        String stagingPath = this.getStringValue(context, "stagingPath");
        String distributionPath = this.getStringValue(context, "distributionPath");
        String movieFilePath = this.getStringValue(context, "encodedPath");
        String packageName = this.getStringValue(context, "fileName");
        String movieFileName = new de.schlichtherle.io.File(movieFilePath).getName();
        logger.info((Object)("Movie name read : " + movieFileName));
        de.schlichtherle.io.File archive = null;
        try {
            archive = ArchiveUtility.openArchive(distributionPath, packageName);
            archive.mkdir();
            logger.info((Object)(" staging path = " + stagingPath));
            logger.info((Object)("distribution path = " + distributionPath));
            File[] list = new de.schlichtherle.io.File(stagingPath).listFiles();
            for (int i = 0; i < list.length; ++i) {
                de.schlichtherle.io.File f = (de.schlichtherle.io.File)list[i];
                logger.info((Object)("Prepare to copy " + f.getName()));
                if (f.getName().equalsIgnoreCase(movieFileName)) continue;
                de.schlichtherle.io.File tarEntry = new de.schlichtherle.io.File((File)archive, f.getName());
                logger.info((Object)(" Tar copy result : " + f.copyTo((File)tarEntry)));
            }
            de.schlichtherle.io.File movieFile = new de.schlichtherle.io.File(movieFilePath);
            de.schlichtherle.io.File movieEntry = new de.schlichtherle.io.File((File)archive, movieFileName);
            movieFile.copyTo((File)movieEntry);
        }
        catch (Exception ex) {
            context.setVariable("processFailureReason", (Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (archive != null) {
                ArchiveUtility.closeArchive(archive);
            }
        }
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value == null ? null : value.toString();
    }
}

