/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.showtime.action.util;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.File;
import org.apache.log4j.Logger;

public final class ArchiveUtility {
    private static final Logger logger = Logger.getLogger(ArchiveUtility.class);

    private ArchiveUtility() {
    }

    public static File openArchive(String archiveFilePath) {
        return new File(archiveFilePath, (ArchiveDetector)ArchiveDetector.ALL);
    }

    public static File openArchive(String folderPath, String archiveFileName) {
        return new File(folderPath, archiveFileName, (ArchiveDetector)ArchiveDetector.ALL);
    }

    public static void closeArchive(File archiveFile) {
        if (archiveFile == null) {
            return;
        }
        try {
            if (archiveFile.isArchive() && archiveFile.getEnclArchive() == null) {
                File.umount((File)archiveFile);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error unmounting archive file: " + archiveFile.toString()), (Throwable)e);
        }
    }

    static {
        File.setDefaultArchiveDetector((ArchiveDetector)ArchiveDetector.ALL);
    }
}

